<?php
    session_start();
    if($_SERVER["REQUEST_METHOD"] == "POST"){
        if(isset($_POST["email"]) and !empty($_POST["id"])){
            $id = $_POST["id"];
            $action_user = $_POST["username"];
            $token_name = $_POST["token_name"];
            $token_addr = $_POST["token_addr"];
            $token_symbol = $_POST["token_symbol"];
            $addr_type = $_POST["addr_type"];
            $status = "active";
            date_default_timezone_set("Africa/Lagos");
            $date = date("d/M/Y");
            $time = date("h:i:a");
            $image = strtolower($token_symbol.".png");
            include "../../functions/dbconn.php";
            
            $sql = "UPDATE site_address SET token_name = :token_name, address = :address, symbol = :symbol, type = :type WHERE id = :id";
            $stmt = $conn->prepare($sql);
            if($stmt->execute([
                ':token_name' => $token_name,
                ':address' => $token_addr,
                ':symbol' => $token_symbol,
                ':type' => $addr_type,
                ':id' => $id
                ])){
                        $error2 =    "<div class='alert alert-success' style='font-size: 14px;'>
                                        <strong><i class='uil uil-info-circle mr-2'></i></strong>Address updated successfully.
                                    </div>";
            }
            
            $url="https://".$pqdn."/app/admin/addresses-plans/addresses.php";
            echo "<script type='text/javascript'>document.location.href='{$url}';</script>";
            echo '<META HTTP-EQUIV="refresh" content="0;URL=' . $url . '">';
        }
        
    }
    
    $user = $_SESSION["approved_user"];
    include "../../functions/parameters.php";
    include "../../functions/dbconn.php";
    $user = $_SESSION["approved_admin"];
    $sql = "SELECT * FROM admins WHERE username = :user";
    
    $stmt = $conn->prepare($sql);
    $stmt->execute(  
                        array(  
                            'user'     =>     $user
                        )  
                    );
    $count = $stmt->rowCount();
    
    if($count > 0 ){
        $result = $stmt -> fetch();
    } else {
        $url="../../admin";
        echo "<script type='text/javascript'>document.location.href='{$url}';</script>";
        echo '<META HTTP-EQUIV="refresh" content="0;URL=' . $url . '">';
    }
    
    $sql2 = "SELECT * FROM site_address WHERE id = :id";
    $stmt2 = $conn->prepare($sql2);
    $stmt2->execute(  
                        array(  
                            'id'     =>     $_GET["id"]
                        )  
                    );
    $count2 = $stmt2->rowCount();
    if($count2 > 0 ){
        $result2 = $stmt2 -> fetch();
    } else {
        $url="../../admin";
        echo "<script type='text/javascript'>document.location.href='{$url}';</script>";
        echo '<META HTTP-EQUIV="refresh" content="0;URL=' . $url . '">';
    }
?>

<!DOCTYPE html>
<html>
    <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Primary Meta Tags -->
    <title>Edit token on site - <?php echo $site_title; ?></title>
    <meta name="title" content="">
    <meta name="description" content="">
    <link rel="icon" href="<?php echo $favicon; ?>"/>
    <!-- Open Graph -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="">
    <meta property="og:title" content="">
    <meta property="og:description" content="">
    <meta property="og:image" itemprop="image" content="">
    <!-- Stylesheet Libraries -->
    <link rel="stylesheet" href="https://unicons.iconscout.com/release/v2.1.11/css/unicons.css">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.0/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@7.12.15/dist/sweetalert2.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=IBM+Plex+Sans:wght@600;700&family=Space+Mono&display=swap" rel="stylesheet"> 
    <link rel="stylesheet" href="assets/css/main.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.0/js/bootstrap.min.js"></script> 
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10.10.1/dist/sweetalert2.all.min.js"></script>


    <style>
        body{
            background: #1B1B1B;
            font-family: 'Space Mono', monospace;
        }
        .row{
            margin: 0px;
            padding: 0px;
        }
        
        .bt-bar-holder{
            background: ;
            width: 100%;
            position: fixed;
            bottom: 0px;
            padding: 0px 35%;
            padding-bottom: 20px;
            left: 50%;
            transform: translate(-50%, 0);
            z-index: 999999999999999;
        }
        @media screen and (max-width: 800px) {
            .bt-bar-holder{
                padding: 4% 7%;
            }
        }
        .bt-bar-holder .bt-bar-inner{
            padding: 10px 1px;
            padding-bottom: 10px;
            background: rgb(31, 31, 31, 0.9);
            border-radius: 33px;
            /* box-shadow: -1px 4px 6px 0px rgba(132,138,144,0.22); */
            border: 1px solid #282828;
        }
        .bt-bar{
            background: ;
            width: 100%;
        }
        .bt-bar a{
            color: #585858;
            font-size: 25px;
            padding: 10px 10px;
            font-family: 'Space Mono', monospace;
            line-height: 0.5;
            border-radius: 33px;
            text-decoration: none;
        }
        .bt-bar a.active{
            background: #703DDD;
            border-radius: 33px;
            padding: 10px;
            color: #FFFFFF;
            box-shadow: 0px 0px 28px 0px rgba(112,61,221,0.44);
        }
        .bt-bar a:hover{
            background: #703DDD;
            border-radius: 33px;
            padding: 10px;
            color: #FFFFFF;
            box-shadow: 0px 0px 28px 0px rgba(112,61,221,0.44);
            transition: 0.5s;
        }
        .bt-bar span{
            font-size: 14px;
        
        }
        .top-bar{
            width: 100%;
            padding: 10px 15px;
            padding-top: 10px;
            padding-left: 5px;
            display: flex;
            border-radius: 44px;
            background: #222222;
            box-shadow: 0px 0px 28px 0px rgba(0,0,0,0.29);
        }
        .top-bar .profile{
            width: 70px;
            background: inherit;
            
            border-radius: 50%;
            margin-left: 10px;
        }
        .top-bar .text{
            margin-left: 15px;
            
            margin-top: 20px;
        }
        .top-bar .text h4{
            font-size: 16px;
            width: 150px;
            text-overflow: ellipsis;
            overflow: hidden;
            white-space: nowrap;
            font-family: 'Space Mono', monospace;
            color: #FFFFFF;
            margin: 0px;
        }
        .top-bar .text p{
            width: 140px;
            text-overflow: ellipsis;
            overflow: hidden;
            white-space: nowrap;
            font-size: 12px;
            font-family: 'Space Mono', monospace;
            color: #DFDFDF;
        }
        .top-bar .notif{
            margin-top: 10px;
            background: ;
            padding: 6px 5px;
            border-radius: 50%;
            position: absolute;
            right: 27px
        }
        .top-bar .notif button{
            background: transparent;
            outline: none;
            border: none;
            padding: none;
        }
        .top-bar .notif i{
            color: #FFFFFF;
            font-size: 25px;
        }
        .top-bar .notif .dot{
            height: 10px;
            width: 10px;
            background: red;
            border-radius: 50%;
            position: absolute;
            right: 45px
        }
        .c1-outer{
            border-radius: 22px;
            background: #222222;
            padding: 0px;
            margin-top: 10px;
            padding-top: 1px;
            box-shadow: 0px 0px 28px 0px rgba(0,0,0,0.05);
        }
        .c1-outer .c1-top{
            
            padding: 10px 5px;
            padding-bottom: 20px;
            border-radius: 12px;
            margin: 10px;
            
        }
        
        .c1-outer .c1-top h4{
            font-family: 'Fjalla One', sans-serif;
            font-size: 18px;
            color: #FFFFFF;
        }
        .c1-outer .c1-top h6{
            font-family: 'Space Mono', monospace;
            font-size: 16px;
            color: #FFFFFF;
        }
        .c1-outer .c1-top span{
            color: #f1f1f1;
        }
        .c1-outer .c1-bottom{
            margin-top: 20px;
            padding: 0px 0px;
            padding-bottom: 10px;
        }
        .c1-outer .c1-bottom .item{
            width: 100%;
            display: flex; 
            align-items: center; 
            justify-content: center;
        }
        .c1-outer .c1-bottom .c1-btn{
            border-radius: 50%;
            padding: 8px 10px;
            background: #282828;
            color: #FFFFFF;
        }
        .c1-outer .c1-bottom .c1-btn i{
            font-size: 28px;
        }
        .c1-outer .c1-bottom .c1-btn:hover{
            background: #FED000;
            color: #000000;
        }
        .c1-outer .c1-bottom .c1-btn.active{
            background: #FED000;
            color: #000000;
        }
        .c1-outer .c1-bottom h4{
            font-family: 'Space Mono', monospace;
            text-align: center;
            color: #FFFFFF;
            font-size: 12px;
            margin-top: 5px;
            margin-left: 0px;
        }
        
        
        .btn{
            min-width: 160px;
            background: #703DDD;
            border-radius: 8px;
            padding: 10px 15px;
            color: #FFFFFF;
            box-shadow: 0px 0px 28px 0px rgba(112,61,221,0.44);
        }
        .btn:hover{
            color: #FFFFFF;
        }
        .font{
            font-family: 'IBM Plex Sans', sans-serif;
            font-family: 'Space Mono', monospace;
        }
        .outer{

        }
        .inner{
            padding-top: 40px;
        }
        .inner .text{
           padding: 0px 0px;
           padding-top: 30px;
           padding-bottom: 20px;
        }
        .inner .text h4{
            text-align: center;
            font-family: 'Space Mono', monospace;
            
            font-size: 20px;
            color: #F1F1F1;
        }
        .form-holder{
            padding: 0px 30px;
        }
        .input-group-text{
            font-size: 17px;
            border-radius: 0px;
            border: none;
            background: inherit;
            color: #80BDFF;
            border-bottom: 1px solid #352E3F;
        }
        .input-group-text i{
            color: #80BDFF;
        }
        .input-group-text.active{
            border-bottom: 1px solid #80BDFF;
        }
        .input-group-append.active{
            border-bottom: 1px solid #80BDFF;
        }
        .form-control{
            font-family: 'Space Mono', monospace;
            border-radius: 0px;
            border: none;
            background: inherit;
            font-size: 15px;
            padding-top: 20px;
            padding-bottom: 18px;
            border-bottom: 1px solid #352E3F;
            color: #F1F1F1;
        }
        .form-control:focus{
            box-shadow: none;
            color: #F1F1F1;
            background: inherit;
        }
        .form-holder .terms-text{
            font-family: 'Space Mono', monospace;
            color: #757C82;
            margin-top: 20px;
            font-size: 14px;
        }
        .form-holder .terms-text a{
            color: #80BDFF;
            text-decoration: none;
        }
        footer{

        }
        footer .inner{
            text-align: center;
        }
        footer .inner .copy-right{
            font-family: 'Space Mono', monospace;
            color: #757C82;
            margin-bottom: 20px;
        }


        .w-btn{
            border-radius: 20px;
            background: #19235A;
            font-family: 'Space Mono', monospace;
            font-weight: 600;
            font-size: 14px;
            font-weight: 400;
            padding: 10px 20px;
            
            color: #FFFFFF;
        }
        .w-btn:hover{
            color: #FFFFFF;
        }
        .error{
            font-weight: 500;
            padding-top: 10px;
            font-size: 14px;
            color: #C73E1D;
        }
        .alert-warning{
            font-size: 12px;
        }
        .profile-container {
           width: 100%;
           display: flex;
           flex-direction: row;
           flex-wrap: wrap;
           justify-content: center;
           align-items: center;
        }
        .profile{
            width: 100px;
            background: #DFDFDF;
            padding: 12px 10px;
            border-radius: 50%;
            margin-left: 10px;
        }
        label{
            color: #f1f1f1;
        }
    </style>
</head>
<body>
    <div class="">
        <div class="mt-3">
            <a href="<?php echo $fqdn; ?>"><img src="<?php echo $logo_light; ?>" class="img-fluid mx-auto d-block" width="80px"/> </a>
        </div>
        <div class="row">
            <div class="col-md-4"></div>
            <div class="col-md-4">
                <?php include "../../admin/header.php"; ?>
                <div class="c1-outer" >
                    <div class="c1-top">
                        <div class="inner" style="padding-top: 0px;">
                            <!--<img src="../images/kycprev.png" class="img-fluid mx-auto d-block" width="200px"/>-->
                            <div class="text">
                                <h4>Edit token (<?php echo $result2["token_name"];?>)</h4>
                            </div>
                            <div class="form-holder">
                                <?php if(isset($error2) and $error2 != ""){ echo $error2;} ?>
                                <form method="POST" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>" name="token" id="token">
                                    
                                    <label class="mt-4 ml-3">Token name</label>
                                    <div class="input-group" id="token_name_err">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" id="token_name_icon"><i class="uil uil-bitcoin"></i></span>
                                        </div>
                                        <input type="text" class="form-control" placeholder="Enter token name e.g Ethereum" id="token_name" name="token_name" value="<?php echo $result2["token_name"];?>">
                                    </div> <br/>
                                    <label class=" ml-3">Token address</label>
                                     <div class="input-group" id="token_addr_err">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" id="token_addr_icon"><i class="uil uil-sign-alt"></i></span>
                                        </div>
                                        <input type="text" class="form-control" placeholder="Token address e.g 0x52d8..." id="token_addr" name="token_addr" value="<?php echo $result2["address"];?>">
                                    </div><br/>
                                    <label class=" ml-3">Token symbol</label>
                                    <div class="input-group" id="token_symbol_err">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" id="token_symbol_icon"><i class="uil uil-trademark-circle"></i></span>
                                        </div>
                                        <input type="text" class="form-control" placeholder="Token symbol e.g ETH, BTC..." id="token_symbol" name="token_symbol" value="<?php echo $result2["symbol"];?>">
                                    </div><br/>
                                    <label class="ml-3">Address type</label>
                                    <div class="input-group" id="addr_type_err">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" id="addr_type_icon"><i class="uil uil-file-question"></i></span>
                                        </div>
                                        <input type="text" class="form-control" placeholder="Address type e.g BEP20, TRC20..." id="addr_type" name="addr_type" value="<?php echo $result2["type"];?>">
                                    <input type="hidden" name="email" value="<?php echo $result['email']; ?>">
                                    </div><br/>
                                    <input type="hidden" name="username" value="<?php echo $result['username']; ?>">
                                    <input type="hidden" name="id" value="<?php echo $_GET['id']; ?>">
                                    <input type="hidden" id="browser" name="browser"/>
                                    <div style="margin-top: 5px;">
                                        <div class="">
                                            <button class="btn mt-2" type="submit" id="kyc-btn">
                                                Update token <i class="uil uil-file-plus-alt"></i>
                                            </button>
                                            <a href="addresses.php" class="mt-4" style="color: ; font-size: 14px; margin-left: 10px;">Go back</a>
                                        </div>
                                    </div>
                                    <!--<div class="terms-text">-->
                                    <!--    <span>By clicking <b>Submit</b> you have read and agreed to <?php echo $site_title; ?> data processing <a href="../terms">Terms & Conditions</a>.</span>-->
                                    <!--</div>-->
                                </form> 
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4"></div>
        </div>
        <!--<div class="mb-4">-->
        <!--    <p><br/>-->
        <!--    <img class="img-fluid mx-auto d-block" width="150px" src="../../images/30137.svg" /></p>-->
        <!--</div>-->
        <div class="p-4"></div>
        <div class="p-4"></div>
    </div>

    <script>
        $(function(){
            $('#token_name').on('focus', function(){
                $('#token_name_icon').addClass('active');
            });
            $('#token_name').on('blur', function(){
                $('#token_name_icon').removeClass('active');
            });
    
            $('#token_addr').on('focus', function(){
                $('#token_addr_icon').addClass('active');
            });
            $('#token_addr').on('blur', function(){
                $('#token_addr_icon').removeClass('active');
            });
            
            $('#token_symbol').on('focus', function(){
                $('#token_symbol_icon').addClass('active');
            });
            $('#token_symbol').on('blur', function(){
                $('#token_symbol_icon').removeClass('active');
            });
            
            $('#addr_type').on('focus', function(){
                $('#addr_type_icon').addClass('active');
            });
            $('#addr_type').on('blur', function(){
                $('#addr_type_icon').removeClass('active');
            });
            
            
            $('#token').submit(function(e) {
                e.preventDefault();
                var token_name = $('#token_name').val();
                var token_addr = $('#token_addr').val();
                var token_symbol = $('#token_symbol').val();
                var addr_type = $('#addr_type').val();
                $(".error").remove();
    
                if (token_name.length < 1) {
                    $('#token_name_err').after('<span class="error mt3" style="color: #C73E1D;"><i class="uil uil-exclamation-triangle"></i> Token name is required!</span>');
                }
                if (token_addr.length < 1) {
                    $('#token_addr_err').after('<span class="error mt3" style="color: #C73E1D;"><i class="uil uil-exclamation-triangle"></i> Token address is required!</span>');
                }
                if (token_symbol.length < 1) {
                    $('#token_symbol_err').after('<span class="error mt3" style="color: #C73E1D;"><i class="uil uil-exclamation-triangle"></i> Token symbol is required!</span>');
                }
                if (addr_type.length < 1) {
                    $('#addr_type_err').after('<span class="error mt3" style="color: #C73E1D;"><i class="uil uil-exclamation-triangle"></i> Token address type is required!</span>');
                }
                
                if (token_name.length > 1 && token_addr.length > 1 && token_symbol.length > 1 && addr_type.length > 1) {
                    token.submit();
                }
            });
        });
    </script>
</body>
</html>