<?php include "../../functions/parameters.php"; ?>

<!DOCTYPE html>
<html>
    <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Primary Meta Tags -->
    <title><?php echo $site_title; ?> - Wallet created</title>
    <meta name="title" content="">
    <meta name="description" content="">
    <link rel="icon" href="<?php echo $favicon; ?>"/>
    <!-- Open Graph -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="">
    <meta property="og:title" content="">
    <meta property="og:description" content="">
    <meta property="og:image" itemprop="image" content="">
    <!-- Stylesheet Libraries -->
    <link rel="stylesheet" href="https://unicons.iconscout.com/release/v2.1.11/css/unicons.css">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.0/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@7.12.15/dist/sweetalert2.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=IBM+Plex+Sans:wght@600;700&family=Space+Mono&display=swap" rel="stylesheet"> 
    <link rel="stylesheet" href="assets/css/main.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.0/js/bootstrap.min.js"></script> 
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10.10.1/dist/sweetalert2.all.min.js"></script>


    <style>
        body{
            background: #1B1434;
        }
        .row{
            margin: 0px;
            padding: 0px;
        }
        .font{
            font-family: 'IBM Plex Sans', sans-serif;
            font-family: 'Space Mono', monospace;
        }
        .outer{

        }
        .inner{
            padding: 0px 20px;
            padding-top: 40px;

        }
        .inner .text{
           padding: 0px 0px;
           padding-top: 30px;
           padding-bottom: 20px;
        }
        .inner .text h4{
            text-align: center;
            font-family: 'Space Mono', monospace;
            
            font-size: 20px;
            color: #F1F1F1;
        }
        .form-holder{
            padding: 0px 30px;
        }
        .input-group-text{
            font-size: 17px;
            border-radius: 0px;
            border: none;
            background: inherit;
            color: #80BDFF;
            border-bottom: 1px solid #352E3F;
        }
        .input-group-text.active{
            border-bottom: 1px solid #80BDFF;
        }
        .input-group-append.active{
            border-bottom: 1px solid #80BDFF;
        }
        .form-control{
            font-family: 'Space Mono', monospace;
            border-radius: 0px;
            border: none;
            background: inherit;
            font-size: 15px;
            padding-top: 20px;
            padding-bottom: 18px;
            border-bottom: 1px solid #352E3F;
            color: #F1F1F1;
        }
        .form-control:focus{
            box-shadow: none;
            color: #F1F1F1;
            background: inherit;
        }
        .form-holder .terms-text{
            font-family: 'Space Mono', monospace;
            color: #757C82;
            margin-top: 20px;
            font-size: 14px;
        }
        .form-holder .terms-text a{
            color: #80BDFF;
        }
        footer{

        }
        footer .inner{
            text-align: center;
        }
        footer .inner .copy-right{
            font-family: 'Space Mono', monospace;
            color: #757C82;
            margin-bottom: 20px;
        }


        .w-btn{
            border-radius: 20px;
            background: #19235A;
            font-family: 'Space Mono', monospace;
            font-weight: 600;
            font-size: 14px;
            font-weight: 400;
            padding: 10px 20px;
            
            color: #FFFFFF;
        }
        .w-btn:hover{
            color: #FFFFFF;
        }
        .new {
            padding: 50px;
            }

            .form-group {
            display: block;
            margin-bottom: 15px;
            }

            .form-group input {
            padding: 0;
            height: initial;
            width: initial;
            margin-bottom: 0;
            display: none;
            cursor: pointer;
            }

            .form-group label {
            position: relative;
            cursor: pointer;
            color: #757C82;
            }

            .form-group label:before {
            content:'';
            -webkit-appearance: none;
            background-color: transparent;
            border: 2px solid #80BDFF;
            border-radius: 50%;
            box-shadow: 0 1px 2px rgba(0, 0, 0, 0.05), inset 0px -15px 10px -12px rgba(0, 0, 0, 0.05);
            padding: 10px;
            display: inline-block;
            position: relative;
            vertical-align: middle;
            cursor: pointer;
            margin-right: 5px;
            }

            .form-group input:checked + label:after {
            content: '';
            display: block;
            position: absolute;
            top: 6px;
            left: 9px;
            width: 6px;
            height: 14px;
            border: solid #80BDFF;
            border-width: 0 2px 2px 0;
            transform: rotate(45deg);
            }
    </style>
</head>
<body>
    <div class="">
        <div class="row">
            <div class="col-md-4"></div>
            <div class="col-md-4">
                <div class="">
                    <div class="inner">
                        <div class="">
                            <a href="<?php echo $site_url; ?>"><img src="<?php echo $logo_light; ?>" class="img-fluid mx-auto d-block" width="150px"/> </a>
                        </div>
                        <img src="../../images/rocket.png" class="img-fluid mx-auto d-block" width="230px"/>
                        <div class="text">
                            <h4>Wallet created<br/> Proceed to Login and Make Deposit to secure your Crypto assets.</h4>
                        </div>
                        <div style="margin-top: 10px;">
                            <button class="btn btn-block w-btn " onclick="window.location='../../login';">Log in</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4"></div>
        </div>
        <div class="p-4 mt-4">
                                    
        </div>
        <div class="p-4 mt-4">
                                    
        </div>
        <div class="p-2  mt-4">
                                    
        </div>
        <footer class="">
            <div class="inner">
                <div class="copy-right">
                    <span>©2025 <?php echo $site_title; ?> Inc.</span>
                </div>
            </div>
        </footer>
    </div>

<script>
    $(function(){
        $('#email').on('focus', function(){
            $('#email_icon').addClass('active');
        });
        $('#email').on('blur', function(){
            $('#email_icon').removeClass('active');
        });

        $('#u_username').on('focus', function(){
            $('#u_username_icon').addClass('active');
        });
        $('#u_username').on('blur', function(){
            $('#u_username_icon').removeClass('active');
        });

        $('#u_password').on('focus', function(){
            $('#u_password_icon').addClass('active');
            $('#togglePassword').addClass('active');
        });
        $('#u_password').on('blur', function(){
            $('#u_password_icon').removeClass('active');
            $('#togglePassword').removeClass('active');
        });

        $('#u_password2').on('focus', function(){
            $('#u_password_icon2').addClass('active');
        });
        $('#u_password2').on('blur', function(){
            $('#u_password_icon2').removeClass('active');
        });
    });
</script>
</body>
</html>