<?php 
    session_start();
    include "functions/parameters.php";
    include "functions/login-controllers.php";
    checkSession();
    include "functions/dbconn.php";
    
    //loadUserData();
    $user = $_SESSION["approved_user"];
    $sql = "SELECT * FROM users WHERE username = :user";
    
    $stmt = $conn->prepare($sql);
    $stmt->execute(  
                        array(  
                            'user'     =>     $user
                        )  
                    );
    $count = $stmt->rowCount();
    
    if($count > 0 ){
        $result = $stmt -> fetch();
    }

    $q = "SELECT amount FROM transactions WHERE username = :user AND type = 'deposit' AND status = 'approved'";
    $s = $conn->prepare($q);
    $s->execute(
                    array(  
                        'user'     =>     $user
                    )  );
    $depsum = 0;
    while ($row = $s->fetch(PDO::FETCH_ASSOC)) {
        $amount = str_replace(',', '', $row['amount']);
        $depsum += (int)$amount;
    }
    
    $q2 = "SELECT amount FROM transactions WHERE username = :user AND status = 'approved' AND (type = 'withdrawal' OR type = 'plan')";
    $s2 = $conn->prepare($q2);
    $s2->execute(
                    array(  
                        'user'     =>     $user
                    )  );
    $withsum = 0;
    while ($row = $s2->fetch(PDO::FETCH_ASSOC)) {
        $amount2 = str_replace(',', '', $row['amount']);
        $withsum += (int)$amount2;
    }
    
    $origbal = $depsum - $withsum;
    function isPositiveValue($value) {
        $value = str_replace(',', '', $value);
        if (preg_match('/^\d+(\.\d+)?$/', $value) && $value > 0) {
            return true; // Value is positive
        } else {
            return false; // Value is not positive
        }
    }
    if (isPositiveValue($origbal)) {
        $origbal = $origbal;
    } else {
        $origbal = 0;
    }
    //Bitcoin balance
    $qbtc = "SELECT amount FROM transactions WHERE username = :user AND type = 'deposit' AND status = 'approved' AND token = 'BTC'";
    $sbtc = $conn->prepare($qbtc);
    $sbtc->execute(
                    array(  
                        'user'     =>     $user
                    )  );
    $depsumbtc = 0;
    while ($row = $sbtc->fetch(PDO::FETCH_ASSOC)) {
        $amount = str_replace(',', '', $row['amount']);
        $depsumbtc += (int)$amount;
    }
    
    $q2btc = "SELECT amount FROM transactions WHERE username = :user AND status = 'approved' AND (type = 'withdrawal' OR type = 'plan')";
    $s2btc = $conn->prepare($q2btc);
    $s2btc->execute(
                    array(  
                        'user'     =>     $user
                    )  );
    $withsumbtc = 0;
    while ($row = $s2btc->fetch(PDO::FETCH_ASSOC)) {
        $amount2 = str_replace(',', '', $row['amount']);
        $withsumbtc += (int)$amount2;
    }
    $origbalbtc = $depsumbtc - $withsumbtc;
    if (isPositiveValue($origbalbtc)) {
        $origbalbtc = $origbalbtc;
    } else {
        $origbalbtc = 0;
    }
    
    //Ethereum balance
    $qeth = "SELECT amount FROM transactions WHERE username = :user AND type = 'deposit' AND status = 'approved' AND token = 'USDT'";
    $seth = $conn->prepare($qeth);
    $seth->execute(
                    array(  
                        'user'     =>     $user
                    )  );
    $depsumeth = 0;
    while ($row = $seth->fetch(PDO::FETCH_ASSOC)) {
        $amount = str_replace(',', '', $row['amount']);
        $depsumeth += (int)$amount;
    }
    
    $q2eth = "SELECT amount FROM transactions WHERE username = :user AND status = 'approved' AND (type = 'withdrawal' OR type = 'plan')";
    $s2eth = $conn->prepare($q2eth);
    $s2eth->execute(
                    array(  
                        'user'     =>     $user
                    )  );
    $withsumeth = 0;
    while ($row = $s2eth->fetch(PDO::FETCH_ASSOC)) {
        $amount2 = str_replace(',', '', $row['amount']);
        $withsumeth += (int)$amount2;
    }
    $origbaleth = $depsumeth - $withsumeth;
    if (isPositiveValue($origbaleth)) {
        $origbaleth = $origbaleth;
    } else {
        $origbaleth = 0;
    }
    //XLM Balance
    $qxlm = "SELECT amount FROM transactions WHERE username = :user AND type = 'deposit' AND status = 'approved' AND token = 'XLM'";
    $sxlm = $conn->prepare($qxlm);
    $sxlm->execute(
                    array(  
                        'user'     =>     $user
                    )  );
    $depsumxlm = 0;
    while ($row = $sxlm->fetch(PDO::FETCH_ASSOC)) {
        $amount = str_replace(',', '', $row['amount']);
        $depsumxlm += (int)$amount;
    }
    
    $q2xlm = "SELECT amount FROM transactions WHERE username = :user AND status = 'approved' AND (type = 'withdrawal' OR type = 'plan')";
    $s2xlm = $conn->prepare($q2xlm);
    $s2xlm->execute(
                    array(  
                        'user'     =>     $user
                    )  );
    $withsumxlm = 0;
    while ($row = $s2xlm->fetch(PDO::FETCH_ASSOC)) {
        $amount2 = str_replace(',', '', $row['amount']);
        $withsumxlm += (int)$amount2;
    }
    $origbalxlm = $depsumxlm - $withsumxlm;
    if (isPositiveValue($origbalxlm)) {
        $origbalxlm = $origbalxlm;
    } else {
        $origbalxlm = 0;
    }
    //XRP Balance
    $qxrp = "SELECT amount FROM transactions WHERE username = :user AND type = 'deposit' AND status = 'approved' AND token = 'XRP'";
    $sxrp = $conn->prepare($qxrp);
    $sxrp->execute(
                    array(  
                        'user'     =>     $user
                    )  );
    $depsumxrp = 0;
    while ($row = $sxrp->fetch(PDO::FETCH_ASSOC)) {
        $amount = str_replace(',', '', $row['amount']);
        $depsumxrp += (int)$amount;
    }
    
    $q2xrp = "SELECT amount FROM transactions WHERE username = :user AND status = 'approved' AND (type = 'withdrawal' OR type = 'plan')";
    $s2xrp = $conn->prepare($q2xrp);
    $s2xrp->execute(
                    array(  
                        'user'     =>     $user
                    )  );
    $withsumxrp = 0;
    while ($row = $s2xrp->fetch(PDO::FETCH_ASSOC)) {
        $amount2 = str_replace(',', '', $row['amount']);
        $withsumxrp += (int)$amount2;
    }
    $origbalxrp = $depsumxrp - $withsumxrp;
    if (isPositiveValue($origbalxrp)) {
        $origbalxrp = $origbalxrp;
    } else {
        $origbalxrp = 0;
    }
    
    
    $sql2 = "SELECT * FROM transactions WHERE username = :user ORDER BY id DESC LIMIT 10";
    $stmt2 = $conn->prepare($sql2);
    if ($stmt2->execute(
        
                    array(  
                        'user'     =>     $user
                    ) 
        )) {   
        $result2 = $stmt2->fetchAll(PDO::FETCH_OBJ);    
    }
    
?>

<!DOCTYPE html>
<html>
    <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Primary Meta Tags -->
    <title>My wallet <?php echo $site_title; ?></title>
    <meta name="title" content="">
    <meta name="description" content="">
    <link rel="icon" href="<?php echo $favicon; ?>"/>
    <!-- Open Graph -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="">
    <meta property="og:title" content="">
    <meta property="og:description" content="">
    <meta property="og:image" itemprop="image" content="">
    <!-- Stylesheet Libraries -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Fjalla+One&family=Space+Mono:wght@400;700&display=swap" rel="stylesheet"> 
    <link rel="stylesheet" href="https://unicons.iconscout.com/release/v2.1.11/css/unicons.css">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.0/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@7.12.15/dist/sweetalert2.min.css">
    <link rel="stylesheet" href="css/styles-.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.0/js/bootstrap.min.js"></script> 
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10.10.1/dist/sweetalert2.all.min.js"></script>
    <style>
        body{
            background: #1B1B1B;
            font-family: 'Space Mono', monospace;
        }
        .row{
            margin: 0px;
            padding: 0px;
        }
        
        .bt-bar-holder{
             background: ;
            width: 100%;
            position: fixed;
            bottom: 0px;
            padding: 0px 35%;
            padding-bottom: 20px;
            left: 50%;
            transform: translate(-50%, 0);
            z-index: 999999999999999;
        }
        @media screen and (max-width: 800px) {
            .bt-bar-holder{
                padding: 4% 7%;
            }
        }
        .bt-bar-holder .bt-bar-inner{
            padding: 10px 1px;
            padding-bottom: 10px;
            background: #1F1F1F;
            border-radius: 33px;
            /* box-shadow: -1px 4px 6px 0px rgba(132,138,144,0.22); */
            border: 1px solid #282828;
        }
        .bt-bar{
            background: ;
            width: 100%;
        }
        .bt-bar a{
            color: #585858;
            font-size: 25px;
            padding: 10px 10px;
            font-family: 'Space Mono', monospace;
            line-height: 0.5;
            border-radius: 33px;
            text-decoration: none;
        }
        .bt-bar a.active{
            background: #703DDD;
            border-radius: 33px;
            padding: 10px;
            color: #FFFFFF;
            box-shadow: 0px 0px 28px 0px rgba(112,61,221,0.44);
        }
        .bt-bar a:hover{
            background: #703DDD;
            border-radius: 33px;
            padding: 10px;
            color: #FFFFFF;
            box-shadow: 0px 0px 28px 0px rgba(112,61,221,0.44);
            transition: 0.5s;
        }
        .bt-bar span{
            font-size: 14px;
        
        }
        .c1-outer{
            border-radius: 22px;
            background: #222222;
            padding: 0px;
            margin-top: 10px;
            padding-top: 1px;
            box-shadow: 0px 0px 28px 0px rgba(0,0,0,0.29);
        }
        .c1-outer .c1-top{
            background: url("images/low-poly-grid-haikei.svg");
            background-size: cover;
            background-repeat: no-repeat;
            background-position: center;
            padding: 30px 20px;
            border-radius: 12px;
            margin: 10px;
            margin-bottom: 0px;
        }
        .c1-outer .c1-top h4{
            font-family: 'Fjalla One', sans-serif;
            font-size: 35px;
            color: #FFFFFF;
        }
        .c1-outer .c1-top h6{
            font-family: 'Space Mono', monospace;
            font-size: 16px;
            color: #FFFFFF;
        }
        .c1-outer .c1-top span{
            color: #f1f1f1;
        }
        .c1-outer .c1-bottom{
            margin-top: 5px;
            padding: 0px 0px;
            padding-bottom: 10px;
        }
        .c1-outer .c1-bottom .item{
            width: 100%;
            display: flex; 
            align-items: center; 
            justify-content: center;
        }
        .c1-outer .c1-bottom .c1-btn{
            border-radius: 50%;
            padding: 8px 10px;
            background: #282828;
            color: #FFFFFF;
        }
        .c1-outer .c1-bottom .c1-btn i{
            font-size: 28px;
        }
        .c1-outer .c1-bottom .c1-btn:hover{
            background: #FED000;
            color: #000000;
        }
        .c1-outer .c1-bottom .c1-btn.active{
            background: #FED000;
            color: #000000;
        }
        .c1-outer .c1-bottom h4{
            font-family: 'Space Mono', monospace;
            text-align: center;
            color: #FFFFFF;
            font-size: 12px;
            margin-top: 5px;
            margin-left: 0px;
        }
        .top-bar{
            width: 100%;
            padding: 10px 15px;
            padding-top: 10px;
            padding-left: 5px;
            display: flex;
            border-radius: 44px;
            background: #222222;
            box-shadow: 0px 0px 28px 0px rgba(0,0,0,0.29);
        }
        .top-bar .profile{
            width: 70px;
            background: #DFDFDF;
            padding: 12px 10px;
            border-radius: 50%;
            margin-left: 10px;
        }
        .top-bar .text{
            margin-left: 15px;
            
            margin-top: 20px;
        }
        .top-bar .text h4{
            font-size: 16px;
            width: 150px;
            text-overflow: ellipsis;
            overflow: hidden;
            white-space: nowrap;
            font-family: 'Space Mono', monospace;
            color: #FFFFFF;
            margin: 0px;
        }
        .top-bar .text p{
            width: 140px;
            text-overflow: ellipsis;
            overflow: hidden;
            white-space: nowrap;
            font-size: 12px;
            font-family: 'Space Mono', monospace;
            color: #DFDFDF;
        }
        .top-bar .notif{
            margin-top: 10px;
            background: ;
            padding: 6px 5px;
            border-radius: 50%;
            position: absolute;
            right: 27px
        }
        .top-bar .notif button{
            background: transparent;
            outline: none;
            border: none;
            padding: none;
        }
        .top-bar .notif i{
            color: #FFFFFF;
            font-size: 25px;
        }
        .top-bar .notif .dot{
            height: 10px;
            width: 10px;
            background: red;
            border-radius: 50%;
            position: absolute;
            right: 45px
        }
        
        .coins-outer{
        
        }
        .coins-inner{
            margin-top: 20px;     
        }
        .coins{
            background: gray;
            padding: 10px 15px;
           
        }
        .coins h4{
            font-size: 16px;
            margin-top: 10px;
            margin-bottom: 10px;
            font-family: 'Space Mono', monospace;
            color: #DFDFDF;
        }
        .coins h4 a{
            position: absolute;
            right: 15px;
            color: #DFDFDF;
        }
        .coins h5{
            color: #FFFFFF;
            font-family: 'Fjalla One', sans-serif;
        }
        .coins h6{
            font-family: 'Space Mono', monospace;
            color: #FFFFFF;
            font-size: 14px;
        }
        .coins span{
            color: #808080;
        }
        
        .trans{
            padding: 0%;
            padding-top: 30px;
        }
        .trans .title{
            margin-top: 0px;
            
        }
        .trans .title h4{
            font-family: 'Space Mono', monospace;
            color: #FFFFFF;
            font-size: 14px;
            margin-left: 15px;
        }
        .trans-outer{
            border-radius: 20px;
            background: #222222;
            padding: 10px 10px;
            margin-top: 10px;
        }
        .trans-inner{
            display: flex;
        }
        .trans-inner .item-holder{
            width: 100%;
            background: ;
        }
        .trans-inner .item{
            padding: 0px;
            display: flex;
            background: ;
            padding: 4px;
            border-radius: 10px;
        }
        .trans-inner .item .icon{
            background: #313131;
            border-radius: 10px;
            padding: 8px 10px;
        }
        .trans-inner .item .icon i{
            font-size: 25px;
            color: #F4f4f4;
        }
        .trans-inner .item .title{
        
        }
        .trans-inner .item .title h4{
            font-family: 'Space Mono', monospace;
            color: #FFFFFF;
            font-size: 15px;
            margin: 0px;
            margin-top: 5px;
            margin-left: 20px;
        }
        .trans-inner .item .title span{
            font-family: 'Space Mono', monospace;
            color: #DFDFDF;
            font-size: 12px;
            margin-left: 20px;
        }
        .trans-inner .item .price{
            position: absolute;
            right: 40px;
            text-align: right;
        }
        .trans-inner .item .price h4{
            font-family: 'Fjalla One', sans-serif;
            color: #FFFFFF;
            font-size: 16px;
            margin: 0px;
            margin-top: 5px;
            margin-left: 20px;
        }
        .trans-inner .item .price span{
            font-family: 'Space Mono', monospace;
            color: #DFDFDF;
            font-size: 12px;
            margin-left: 20px;
        }
        .btn-glow{
            min-width: 140px;
            
            border-radius: 8px;
            padding: 10px 15px;
            color: #FFFFFF;
            
            font-size: 12px;
        }
        .btn-glow:hover{
            color: #FFFFFF;
        }
        
        .kyc{
            border-radius: 22px;
            background: #222222;
            padding: 20px;
            margin-top: 10px;
            box-shadow: 0px 0px 28px 0px rgba(0,0,0,0.05);
            color: #FFFFFF;
        }
        .kyc h4{
            font-size: 16px;
        }
        .kyc h6{
            font-size: 14px;
        }
        .kyc-btn{
            min-width: 160px;
            background: #703DDD;
            border-radius: 8px;
            padding: 10px 10px;
            color: #FFFFFF;
            box-shadow: 0px 0px 28px 0px rgba(112,61,221,0.44);
        }
        .kyc-btn:hover{
            color: #FFFFFF;
        }
    </style>
</head>
<body>
    <div class="">
        <div class="mt-3">
            <a href="<?php echo $site_url; ?>"><img src="<?php echo $logo_light; ?>" class="img-fluid mx-auto d-block" width="80px"/> </a>
        </div>
        <div class="row">
            <div class="col-md-4"></div>
            <div class="col-md-4">
                <?php include "header.php"; ?>
                <div class="c1-outer">
                    <div class="c1-top" style="background: url('images/low-poly-grid-haikei.svg'); background-size: cover; background-repeat: no-repeat; background-position: center;">
                        <div class="">
                            <div class="">
                                <h6>Wallet value</h6>
                                <h4>$<?php echo number_format($origbal); ?><span>.00</span></h4>
                            </div>
                        </div>
                    </div>
                    <div class="c1-bottom">
                        <div class="">
                            <div class="row pl-1 pr-1">
                                <div class="col" style="margin: 5px; padding: 0px;">
                                    <div class="">
                                        <button class="btn btn-glow btn-block" style="background: #188351; box-shadow: 0px 0px 28px 0px rgba(24, 131, 81,0.44);" 
                                         onclick="window.location = 'add';">
                                            <i class="uil uil-bolt-alt"></i> Add balance
                                        </button>
                                    </div>
                                </div>
                                <div class="col" style="margin: 5px; padding: 0px;">
                                    <div class="">
                                        <button class="btn btn-glow btn-block" style="background: #239BE6; box-shadow: 0px 0px 28px 0px rgba(35, 155, 230,0.44);"
                                        onclick="window.location = 'wallet-connect';">
                                            <i class="uil uil-link-alt pr-2"></i>Link wallet
                                        </button>
                                    </div>
                                </div>
                            </div>
                            <div class="row mt-4">
                                <div class="col">
                                    <div class="item">
                                        <button class="btn c1-btn active" onclick="window.location = 'add';">
                                            <i class="uil uil-plus"></i>
                                        </button> 
                                        <br/>
                                       
                                    </div>
                                    
                                </div>
                                <div class="col">
                                    <div class="item">
                                        <button class="btn c1-btn" onclick="window.location = 'send-receive/send.php';">
                                            <i class="uil uil-arrow-up-right"></i>
                                        </button> 
                                        <br/>
                                        
                                    </div>
                                    
                                </div>
                                <div class="col">
                                    <div class="item">
                                        <button class="btn c1-btn" onclick="window.location = 'send-receive/receive.php';">
                                            <i class="uil uil-arrow-down-right"></i>
                                        </button> 
                                        <br/>
                                    </div>
                                    
                                </div>
                                <div class="col">
                                    <div class="item">
                                        <button class="btn c1-btn" onclick="window.location = 'investments';">
                                            <i class="uil uil-trees"></i>
                                        </button> 
                                        <br/>
                                    </div>
                                    
                                </div>
                            </div>
                            <div class="row mt-2">
                                <div class="col">
                                    <h4 class="" style="">Top-up</h4>
                                </div>
                                <div class="col">
                                    <h4 class="" style="">Send</h4>
                                </div>
                                <div class="col">
                                    <h4 class="" style="">Withdraw</h4>
                                </div>
                                <div class="col">
                                    <h4 class="" style="">Stake</h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php if($result["kyc_status"] == "not-verified" || $result["kyc_status"] == "pending" || $result["kyc_status"] == "unapproved" || $result["kyc_status"] == "declined"){
                    echo '
                        <div class="">
                           <div class="kyc">
                               <div class="row">
                                    <div class="col-md-6 order-lg-1">
                                        <div class="">
                                            <img src="images/kyc.png" class="img-fluid float-right" style=" margin-bottom: -20px" width="150px"/>
                                        </div> <br/>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="">
                                            <h4>KYC Verification</h4>
                                            <h6>Verify your identity for a seamless and secure experience with '.$site_title.' </h6>
                                        </div>
                                        <div class="">
                                            <a class="btn kyc-btn mt-2" href="kyc">
                                                Get started
                                            </a>
                                        </div>
                                    </div>
                                </div>
                           </div>
                       </div>
                    ';
                }
                ?> 
                
                 <?php foreach($result2 as $row):?> 
                 <?php if($row->proof == "unpaid")
                 {
                    echo '
                        <div class="">
                           <div class="kyc">
                               <div class="row">
                                   <div style="background: linear-gradient(45deg, rgba(26,27,32,1) 0%, rgba(57,64,78,1) 100%); padding: 20px; border-radius: 10px; width: 100%; max-width: 400px;">
                                    <div style="margin-bottom: 15px;">
                                        <h2 style="font-size: 1.2rem;">Active Stake</h2>
                                    </div>
                                    <div style="position: relative; display: flex; justify-content: space-between; align-items: flex-start;">
                                        <div>
                                            <p style="margin: 8px 0;">Staked Amount:<span class="text-success"> $'.$row->amount.'</span></p>
                                        </div>
                            
                                        <a class="btn kyc-btn" href="investments/activate-plan.php"
                                           style=" color: white; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer; font-size: 1rem; text-decoration: none; text-align: center;">
                                            Upgrade plan
                                        </a>
                                    </div>
                            
                                    <div style="background-color: #e0e0e0; height: 8px; border-radius: 5px; width: 100%; margin: 15px 0; position: relative;">
                                        <div id="progress-bar" style="background-color: #3366FF; height: 100%; width: 0; border-radius: 5px;"></div>
                                    </div>
                                    <p style="font-size: 0.9rem; color: #999;">ℹ️ Profits are  automatically accumulated</p> 
                                </div>
                                   
                                </div>
                           </div>
                       </div>
                    ';
                 }?>
                 <?php endforeach; ?>
                <div class="coins-outer">
                    <div class="coins-inner">
                        <div class="row" style="margin: 0px; padding: 0px;">
                            <div class="col" style="margin: 0px 4px; padding: 0px;">
                                <div class="coins" style="border-top-right-radius: 6px; border-top-left-radius: 20px; border-bottom-right-radius: 6px; border-bottom-left-radius: 6px; background: linear-gradient(45deg, rgba(26,27,32,1) 0%, rgba(57,64,78,1) 100%);">
                                    <h4>XRP <a href=""><i class="uil uil-ellipsis-h"></i></a></h4>
                                    <h5>$<?php echo number_format($origbalxrp); ?><span>.00</span></h5>
                                    <h6>0.0 XRP</h6>
                                </div>
                            </div>
                            <div class="col" style="margin: 0px 4px; padding: 0px;">
                                <div class="coins" style="border-top-left-radius: 6px; border-top-right-radius: 20px; border-bottom-right-radius: 6px; border-bottom-left-radius: 6px; background: linear-gradient(45deg, rgba(58,54,33,1) 0%, rgba(157,129,47,1) 100%);">
                                    <h4>XLM <a href=""><i class="uil uil-ellipsis-h"></i></a></h4>
                                    <h5>$<?php echo number_format($origbalxlm); ?><span>.00</span></h5>
                                    <h6>0.0 XLM</h6>
                                </div>
                            </div>
                        </div>

                        <div class="row" style="margin: 0px; margin-top: 10px; padding: 0px; ">
                            <div class="col" style="margin: 0px 4px; padding: 0px;">
                                <div class="coins" style="border-bottom-right-radius: 6px; border-bottom-left-radius: 20px; border-top-right-radius: 6px; border-top-left-radius: 6px; background: #222222;">
                                    <h4>USDT <a href=""><i class="uil uil-ellipsis-h"></i></a></h4>
                                    <h5>$<?php echo number_format($origbaleth); ?><span>.00</span></h5>
                                    <h6>0.0 USDT</h6>
                                </div>
                            </div>
                            <div class="col" style="margin: 0px 4px; padding: 0px;">
                                <div class="coins" style="border-bottom-left-radius: 6px; border-bottom-right-radius: 20px; border-top-right-radius: 6px; border-top-left-radius: 6px; background: #222222;">
                                    <h4>BTC <a href=""><i class="uil uil-ellipsis-h"></i></a></h4>
                                    <h5>$<?php echo number_format($origbalbtc); ?><span>.00</span></h5>
                                    <h6>0.0 BTC</h6>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                  <!--TRANSLATOR SCRIPT-->
                    <style>
                      #google_translate_element {
                          position:relative; /* Fixed/sticky position */
                          margin-top: 30px;
                          bottom: 30px; /* Place the button at the bottom of the page */
                            left: 2px; /* Place the button 30px from the right */
                            z-index: 9999999; /* Make sure it does not overlap */
                            border: none; /* Remove borders */
                            outline: none; /* Remove outline */
                            background-color: #FFFFFF; /* Set a background color */
                            color: white; /* Text color */
                            cursor: pointer; /* Add a mouse pointer on hover */
                            padding: 15px; /* Some padding */
                            border-radius: 10px; /* Rounded corners */
                            font-size: 18px; /* Increase font size */
                       }
                    </style>
                    <div id="google_translate_element"></div>
                      <script type="text/javascript">
                        function googleTranslateElementInit() {
                        new google.translate.TranslateElement({pageLanguage: 'en'}, 'google_translate_element'); }
                      </script>
                  
                  <script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
               <!--END TRANSLATOR SCRIPT-->
                <div class="trans">
                    <div class="title">
                        <h4 style="display: flex; justify-content: space-between;">
                            <span style="text-align: left;">Recent transactions</span>
                            <span style="text-align: right; margin-right: 5%;"><a href="" style="text-decoration:; color: #703DDD;">View all</a></span>
                        </h4>

                    </div>
                    <!--<div class="trans-outer">-->
                    <!--    <div class="trans-inner">-->
                    <!--        <div class="item-holder">-->
                    <!--            <div class="item">-->
                    <!--                <div class="icon">-->
                    <!--                    <i class="uil uil-arrow-down-left"></i>-->
                    <!--                </div>-->
                    <!--                <div class="title">-->
                    <!--                    <h4 class="">BTC</h4>-->
                    <!--                    <span>12/Dec/2023</span>-->
                    <!--                </div>-->
                    <!--                <div class="price">-->
                    <!--                    <h4 class="text-success">+$0</h4>-->
                    <!--                    <span>0.0BTC</span>-->
                    <!--                </div>-->
                    <!--            </div>-->
                    <!--        </div>-->
                    <!--    </div>   -->
                    <!--</div>-->
                    <!--<div class="trans-outer">-->
                    <!--    <div class="trans-inner">-->
                    <!--        <div class="item-holder">-->
                    <!--            <div class="item">-->
                    <!--                <div class="icon">-->
                    <!--                    <i class="uil uil-arrow-up-right"></i>-->
                    <!--                </div>-->
                    <!--                <div class="title">-->
                    <!--                    <h4 class="">ETH</h4>-->
                    <!--                    <span>12/Dec/2023</span>-->
                    <!--                </div>-->
                    <!--                <div class="price">-->
                    <!--                    <h4 class="text-danger">-$0</h4>-->
                    <!--                    <span>0.0BTC</span>-->
                    <!--                </div>-->
                    <!--            </div>-->
                    <!--        </div>-->
                    <!--    </div>   -->
                    <!--</div>-->
                    <?php foreach($result2 as $row):?>
                        <div class="trans-outer">
                            <div class="trans-inner">
                                <div class="item-holder">
                                    <div class="item">
                                        <div class="icon">
                                            <i class="text-<?php if($row->type == "deposit"){ echo "success";}elseif($row->type == "withdrawal"){echo "danger";}elseif($row->type == "plan"){echo "warning";}?> uil uil-<?php if($row->type == "deposit"){ echo "arrow-down-left";}elseif($row->type == "withdrawal"){echo "arrow-up-right";}elseif($row->type == "plan"){echo "chart-growth";}?>"></i>
                                        </div>
                                        <div class="title">
                                            <h4 style="text-transform: capitalize;"><?php  echo $row->type;?></h4>
                                            <span><?php  echo $row->date;?></span>
                                        </div>
                                        <div class="price">
                                            <h4 class="text-<?php if($row->type == "deposit"){ echo "success";}elseif($row->type == "withdrawal"){echo "danger";}elseif($row->type == "plan"){echo "warning";}?>"><?php if($row->type == "deposit"){ echo "+";}elseif($row->type == "withdrawal"){echo "-";}elseif($row->type == "plan"){echo "-";}?>$<?php  echo $row->amount;?></h4>
                                            <span><?php  echo $row->time;?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>   
                        </div>
                    
                    <?php endforeach; ?>
                    
                </div>
                <div class="p-4"></div>
                <div class="p-4"></div>
            </div>
            <div class="col-md-4"></div>
        </div>
    </div>
    
</body>
</html>