<?php
    session_start();
    if($_SERVER["REQUEST_METHOD"] == "POST"){
        include "../functions/dbconn.php";
        if(isset($_POST["email"])){
            $query = "SELECT * FROM users WHERE email = :email";  
            $stmt = $conn->prepare($query);  
            
            $stmt->execute(  
                    array(  
                        'email'     =>     $_POST["email"]
                    )  
            );
            $result = $stmt -> fetch();
        }
        if(isset($_POST["sid"])){
            $id = $_POST["id"];
            $phone = $_POST["num"];
            $full_name = $_POST["fname"]." ".$_POST["lname"];
            $addr = $_POST["addr"];
            $ssn = $_POST["sid"];
            $dob = $_POST["dob"];
            $kyc_status = "pending";
            $allowedExtensions = array('png', 'jpg', 'gif', 'jpeg', 'pdf');
            function generateUniqueFilename($length = 10) {
                $characters = '0123456789abcdefghijklmnopqrstuvwxyz';
                $randomString = '';
                
                for ($i = 0; $i < $length; $i++) {
                    $randomString .= $characters[rand(0, strlen($characters) - 1)];
                }
                
                return $randomString;
            }
            
            if (isset($_FILES['customFile']) && $_FILES['customFile']['error'] === UPLOAD_ERR_OK && isset($_FILES['customFile2']) && $_FILES['customFile2']['error'] === UPLOAD_ERR_OK) {
                $file = $_FILES['customFile'];
                $file2 = $_FILES['customFile2'];
                $extension = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
                $extension2 = strtolower(pathinfo($file2['name'], PATHINFO_EXTENSION));
                if (in_array($extension, $allowedExtensions) && in_array($extension2, $allowedExtensions)) {
                    // Generate a unique filename
                    $filename = generateUniqueFilename() . '.' . $extension;
                    $filename2 = generateUniqueFilename() . '.' . $extension;
                    
                    $destination = '../uploads/' . $filename;
                    $destination2 = '../uploads/' . $filename2;
                    if (move_uploaded_file($file['tmp_name'], $destination) && move_uploaded_file($file2['tmp_name'], $destination2)) {
                        $kyc_front = $filename;
                        $kyc_back = $filename2;
                        $sql = "UPDATE users SET phone = :phone, full_name = :full_name, address = :addr, kyc_front = :kyc_front, kyc_back =:kyc_back, kyc_status = :kyc_status, ssn = :ssn, dob = :dob WHERE id = :id";
                        $stmt2 = $conn->prepare($sql);
                        if($stmt2->execute([
                            ':phone' => $phone,
                            ':full_name' => $full_name,
                            ':addr' => $addr,
                            ':kyc_front' => $kyc_front,
                            ':kyc_back' => $kyc_back,
                            ':ssn' => $ssn,
                            ':dob' => $dob,
                            ':kyc_status' => $kyc_status,
                            ':id' => $id
                            ])){                                                                                                                                                   
                        }
                        
                        $url="https://".$pqdn."/app/kyc/success";
                        echo "<script type='text/javascript'>document.location.href='{$url}';</script>";
                        echo '<META HTTP-EQUIV="refresh" content="0;URL=' . $url . '">';
                    } else {
                        $error =    "<div class='alert alert-danger' style='font-size: 14px;'>
                                    <strong><i class='uil uil-info-circle mr-2'></i></strong>Failed to upload proof!
                                </div>";
                    }
                } else {
                    $error =    "<div class='alert alert-danger' style='font-size: 14px;'>
                                    <strong><i class='uil uil-info-circle mr-2'></i></strong>Invalid file type for proof.
                                </div>";
                }
            } else {
                $error =    "<div class='alert alert-danger' style='font-size: 14px;'>
                                    <strong><i class='uil uil-info-circle mr-2'></i></strong>No file uploaded or an error occured, try again.
                                </div>";
            }
        } else {
            echo 0;
        }
        
    }
    include "../functions/parameters.php";
    include "../functions/dbconn.php";
    
    if (session_status() === PHP_SESSION_ACTIVE) {
        if (isset($_SESSION['approved_user']) and $_SESSION['approved_user'] != "") {
            
            
        } else {
            $url="https://".$pqdn."/app/welcome";
            echo "<script type='text/javascript'>document.location.href='{$url}';</script>";
            echo '<META HTTP-EQUIV="refresh" content="0;URL=' . $url . '">';
        }
    } else {
        $url="https://".$pqdn."/app/welcome";
        echo "<script type='text/javascript'>document.location.href='{$url}';</script>";
        echo '<META HTTP-EQUIV="refresh" content="0;URL=' . $url . '">';
    }
    $user = $_SESSION["approved_user"];
    $sql = "SELECT * FROM users WHERE username = :user";
    
    $stmt = $conn->prepare($sql);
    $stmt->execute(  
                        array(  
                            'user'     =>     $user
                        )  
                    );
    $count = $stmt->rowCount();
    
    if($count > 0 ){
        $result = $stmt -> fetch();
    }
    $sql2 = "SELECT * FROM site_address";
        
    $stmt2 = $conn->prepare($sql2);
    
    if ($stmt2->execute()) {   
    $result2 = $stmt2->fetchAll(PDO::FETCH_OBJ);    
    }
    
    
?>

<!DOCTYPE html>
<html>
    <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Primary Meta Tags -->
    <title>Complete KYC for your <?php echo $site_title; ?> account</title>
    <meta name="title" content="">
    <meta name="description" content="">
    <link rel="icon" href="<?php echo $favicon; ?>"/>
    <!-- Open Graph -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="">
    <meta property="og:title" content="">
    <meta property="og:description" content="">
    <meta property="og:image" itemprop="image" content="">
    <!-- Stylesheet Libraries -->
    <link rel="stylesheet" href="https://unicons.iconscout.com/release/v2.1.11/css/unicons.css">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.0/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@7.12.15/dist/sweetalert2.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=IBM+Plex+Sans:wght@600;700&family=Space+Mono&display=swap" rel="stylesheet"> 
    <link rel="stylesheet" href="assets/css/main.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.0/js/bootstrap.min.js"></script> 
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10.10.1/dist/sweetalert2.all.min.js"></script>


    <style>
        body{
            background: #1B1B1B;
            font-family: 'Space Mono', monospace;
        }
        .row{
            margin: 0px;
            padding: 0px;
        }
        
        .bt-bar-holder{
            background: ;
            width: 100%;
            position: fixed;
            bottom: 0px;
            padding: 0px 35%;
            padding-bottom: 20px;
            left: 50%;
            transform: translate(-50%, 0);
            z-index: 999999999999999;
        }
        @media screen and (max-width: 800px) {
            .bt-bar-holder{
                padding: 4% 7%;
            }
        }
        .bt-bar-holder .bt-bar-inner{
            padding: 10px 1px;
            padding-bottom: 10px;
            background: rgb(31, 31, 31, 0.9);
            border-radius: 33px;
            /* box-shadow: -1px 4px 6px 0px rgba(132,138,144,0.22); */
            border: 1px solid #282828;
        }
        .bt-bar{
            background: ;
            width: 100%;
        }
        .bt-bar a{
            color: #585858;
            font-size: 25px;
            padding: 10px 10px;
            font-family: 'Space Mono', monospace;
            line-height: 0.5;
            border-radius: 33px;
            text-decoration: none;
        }
        .bt-bar a.active{
            background: #703DDD;
            border-radius: 33px;
            padding: 10px;
            color: #FFFFFF;
            box-shadow: 0px 0px 28px 0px rgba(112,61,221,0.44);
        }
        .bt-bar a:hover{
            background: #703DDD;
            border-radius: 33px;
            padding: 10px;
            color: #FFFFFF;
            box-shadow: 0px 0px 28px 0px rgba(112,61,221,0.44);
            transition: 0.5s;
        }
        .bt-bar span{
            font-size: 14px;
        
        }
        .top-bar{
            width: 100%;
            padding: 10px 15px;
            padding-top: 10px;
            padding-left: 5px;
            display: flex;
            border-radius: 44px;
            background: #222222;
            box-shadow: 0px 0px 28px 0px rgba(0,0,0,0.29);
        }
        .top-bar .profile{
            width: 70px;
            background: #DFDFDF;
            padding: 12px 10px;
            border-radius: 50%;
            margin-left: 10px;
        }
        .top-bar .text{
            margin-left: 15px;
            
            margin-top: 20px;
        }
        .top-bar .text h4{
            font-size: 16px;
            width: 150px;
            text-overflow: ellipsis;
            overflow: hidden;
            white-space: nowrap;
            font-family: 'Space Mono', monospace;
            color: #FFFFFF;
            margin: 0px;
        }
        .top-bar .text p{
            width: 140px;
            text-overflow: ellipsis;
            overflow: hidden;
            white-space: nowrap;
            font-size: 12px;
            font-family: 'Space Mono', monospace;
            color: #DFDFDF;
        }
        .top-bar .notif{
            margin-top: 10px;
            background: ;
            padding: 6px 5px;
            border-radius: 50%;
            position: absolute;
            right: 27px
        }
        .top-bar .notif button{
            background: transparent;
            outline: none;
            border: none;
            padding: none;
        }
        .top-bar .notif i{
            color: #FFFFFF;
            font-size: 25px;
        }
        .top-bar .notif .dot{
            height: 10px;
            width: 10px;
            background: red;
            border-radius: 50%;
            position: absolute;
            right: 45px
        }
        .c1-outer{
            border-radius: 22px;
            background: #222222;
            padding: 0px;
            margin-top: 10px;
            padding-top: 1px;
            box-shadow: 0px 0px 28px 0px rgba(0,0,0,0.05);
        }
        .c1-outer .c1-top{
            
            padding: 10px 5px;
            padding-bottom: 20px;
            border-radius: 12px;
            margin: 10px;
            
        }
        
        .c1-outer .c1-top h4{
            font-family: 'Fjalla One', sans-serif;
            font-size: 18px;
            color: #FFFFFF;
        }
        .c1-outer .c1-top h6{
            font-family: 'Space Mono', monospace;
            font-size: 16px;
            color: #FFFFFF;
        }
        .c1-outer .c1-top span{
            color: #f1f1f1;
        }
        .c1-outer .c1-bottom{
            margin-top: 20px;
            padding: 0px 0px;
            padding-bottom: 10px;
        }
        .c1-outer .c1-bottom .item{
            width: 100%;
            display: flex; 
            align-items: center; 
            justify-content: center;
        }
        .c1-outer .c1-bottom .c1-btn{
            border-radius: 50%;
            padding: 8px 10px;
            background: #282828;
            color: #FFFFFF;
        }
        .c1-outer .c1-bottom .c1-btn i{
            font-size: 28px;
        }
        .c1-outer .c1-bottom .c1-btn:hover{
            background: #FED000;
            color: #000000;
        }
        .c1-outer .c1-bottom .c1-btn.active{
            background: #FED000;
            color: #000000;
        }
        .c1-outer .c1-bottom h4{
            font-family: 'Space Mono', monospace;
            text-align: center;
            color: #FFFFFF;
            font-size: 12px;
            margin-top: 5px;
            margin-left: 0px;
        }
        
        
        .btn{
            min-width: 160px;
            background: #703DDD;
            border-radius: 8px;
            padding: 10px 15px;
            color: #FFFFFF;
            box-shadow: 0px 0px 28px 0px rgba(112,61,221,0.44);
        }
        .btn:hover{
            color: #FFFFFF;
        }
        .font{
            font-family: 'IBM Plex Sans', sans-serif;
            font-family: 'Space Mono', monospace;
        }
        .outer{

        }
        .inner{
            padding-top: 40px;
        }
        .inner .text{
           padding: 0px 0px;
           padding-top: 30px;
           padding-bottom: 20px;
        }
        .inner .text h4{
            text-align: center;
            font-family: 'Space Mono', monospace;
            
            font-size: 20px;
            color: #F1F1F1;
        }
        .form-holder{
            padding: 0px 30px;
        }
        .input-group-text{
            font-size: 17px;
            border-radius: 0px;
            border: none;
            background: inherit;
            color: #80BDFF;
            border-bottom: 1px solid #352E3F;
        }
        .input-group-text i{
            color: #80BDFF;
        }
        .input-group-text.active{
            border-bottom: 1px solid #80BDFF;
        }
        .input-group-append.active{
            border-bottom: 1px solid #80BDFF;
        }
        .form-control{
            font-family: 'Space Mono', monospace;
            border-radius: 0px;
            border: none;
            background: inherit;
            font-size: 15px;
            padding-top: 20px;
            padding-bottom: 18px;
            border-bottom: 1px solid #352E3F;
            color: #F1F1F1;
        }
        .form-control:focus{
            box-shadow: none;
            color: #F1F1F1;
            background: inherit;
        }
        .form-holder .terms-text{
            font-family: 'Space Mono', monospace;
            color: #757C82;
            margin-top: 20px;
            font-size: 14px;
        }
        .form-holder .terms-text a{
            color: #80BDFF;
            text-decoration: none;
        }
        footer{

        }
        footer .inner{
            text-align: center;
        }
        footer .inner .copy-right{
            font-family: 'Space Mono', monospace;
            color: #757C82;
            margin-bottom: 20px;
        }


        .w-btn{
            border-radius: 20px;
            background: #19235A;
            font-family: 'Space Mono', monospace;
            font-weight: 600;
            font-size: 14px;
            font-weight: 400;
            padding: 10px 20px;
            
            color: #FFFFFF;
        }
        .w-btn:hover{
            color: #FFFFFF;
        }
        .error{
            font-weight: 500;
            padding-top: 10px;
            font-size: 14px;
            color: #C73E1D;
        }
        .alert-warning{
            font-size: 12px;
        }
    </style>
</head>
<body>
    <div class="">
        <div class="mt-3">
            <a href="<?php echo $site_url; ?>"><img src="<?php echo $logo_light; ?>" class="img-fluid mx-auto d-block" width="80px"/> </a>
        </div>
        <div class="row">
            <div class="col-md-4"></div>
            <div class="col-md-4">
                <?php include "../header.php"; ?>
                <div class="c1-outer">
                    <div class="c1-top" >
                        <div class="row">
                            <div class="col-md-6 order-lg-1">
                                <div class="">
                                    <img src="../images/kyc.png" class="img-fluid float-right" style=" margin-bottom: -20px" width="200px"/>
                                </div> <br/>
                            </div>
                            <div class="col-md-6">
                                <div class="">
                                    <h4>KYC Exercise</h4>
                                    <h6>Kindly fill the form below with your accurate information to remove restrictions from your <?php echo $site_title; ?> account.</h6>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="c1-outer" >
                    <div class="c1-top">
                        <div class="inner" style="padding-top: 0px;">
                            <!--<img src="../images/kycprev.png" class="img-fluid mx-auto d-block" width="200px"/>-->
                            <div class="text">
                                <h4>Personal information.</h4>
                            </div>
                            <div class="form-holder">
                                <?php if(isset($error) and $error != ""){ echo $error;} ?>
                                <form method="POST" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>" name="kyc" id="kyc" enctype="multipart/form-data">
                                    <div class="input-group" id="fname_err">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" id="fname_icon"><i class="uil uil-user-circle"></i></span>
                                        </div>
                                        <input type="text" class="form-control" placeholder="Your firstname" id="fname" name="fname">
                                    </div>
                                    <div class="input-group mt-3" id="lname_err">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" id="lname_icon"><i class="uil uil-user-square"></i></span>
                                        </div>
                                        <input type="text" class="form-control" placeholder="Your lastname" id="lname" name="lname">
                                    </div>
                                    <div class="input-group mt-3" id="addr_err">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" id="addr_icon"><i class="uil uil-map-pin"></i></span>
                                        </div>
                                        <input type="text" class="form-control" placeholder="Full address" id="addr" name="addr">
                                    </div>
                                    <div class="input-group mt-3" id="dob_err">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" id="dob_icon"><i class="uil uil-baby-carriage"></i></span>
                                        </div>
                                        <input type="text" class="form-control" placeholder="(DOB) DD/MM/YYYY" id="dob" name="dob" maxlength="10" onkeyup="formatDate(event);">
                                    </div>
                                    <div class="input-group mt-3" id="sid_err">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" id="sid_icon"><i class="uil uil-user-md"></i></span>
                                        </div>
                                        <input type="text" class="form-control" placeholder="Your email address" id="sid" name="sid">
                                    </div>
                                    <div class="input-group mt-3" id="num_err">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" id="num_icon"><i class="uil uil-phone-volume"></i></span>
                                        </div>
                                        <input type="text" class="form-control" placeholder="Your phone number" id="num" name="num">
                                    </div>
                                    
                                     <div class="terms-text">
                                        <span>Upload clear pictures of your passport or driver's license below: <a style="text-decoration: underline;" href="../support"> Why do we need this?</a></span>
                                    </div>
                                    
                                    <div class="custom-file mt-2" id="file_err">
                                        <input type="file" class="custom-file-input" id="customFile" name="customFile" style="background: #222222;">
                                        <label class="custom-file-label" for="customFile" style="background: #222222; color: #F1F1F1; font-size: 14px; border-top: 0px; border-left: 0px; border-right: 0px; border-radius: 0px;">Upload front</label>
                                    </div>
                                     <div class="custom-file mt-2" id="file_err2">
                                        <input type="file" class="custom-file-input" id="customFile2" name="customFile2" style="background: #222222;">
                                        <label class="custom-file-label" for="customFile" style="background: #222222; color: #F1F1F1; font-size: 14px; border-top: 0px; border-left: 0px; border-right: 0px; border-radius: 0px;">Upload back</label>
                                    </div>
                                    <div class="terms-text">
                                        <span>Need help? <a style="text-decoration: underline;" href="../support"> Contact support</a></span>
                                    </div>
                                    <div class="row mt-2">
                                        
                                    </div>
                                    <input type="hidden" name="email" value="<?php echo $result['email']; ?>">
                                    <input type="hidden" name="id" value="<?php echo $result['id']; ?>">
                                    <input type="hidden" id="browser" name="browser"/>
                                    <div style="margin-top: 10px;">
                                        <div class="">
                                            <button class="btn mt-2" type="submit" id="kyc-btn">
                                                Submit
                                            </button>
                                        </div>
                                    </div>
                                    <div class="terms-text">
                                        <span>By clicking <b>Submit</b> you have read and agreed to <?php echo $site_title; ?> data processing <a href="../terms">Terms & Conditions</a>.</span>
                                    </div>
                                </form> 
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4"></div>
        </div>
        <div class="mb-4">
            <p><br/>
            <img class="img-fluid mx-auto d-block" width="150px" src="../images/30137.svg" /></p>
        </div>
        <div class="p-4"></div>
        <div class="p-4"></div>
    </div>

<script>
        function formatDate(event) {
              const input = event.target;
              let value = input.value.replace(/\D/g, '');
            
              if (value.length > 2) {
                value = value.replace(/^(\d{2})(\d{0,2})/, '$1/$2');
              }
            
              if (value.length > 5) {
                value = value.replace(/^(\d{2})\/(\d{2})(\d{0,4})/, '$1/$2/$3');
              }
            
              input.value = value;
        } 
        $(".custom-file-input").on("change", function() {
          var fileName = $(this).val().split("\\").pop();
          $(this).siblings(".custom-file-label").addClass("selected").html(fileName);
        });
        $(function(){
        
        $('#fname').on('focus', function(){
            $('#fname_icon').addClass('active');
        });
        $('#fname').on('blur', function(){
            $('#fname_icon').removeClass('active');
        });

        $('#lname').on('focus', function(){
            $('#lname_icon').addClass('active');
        });
        $('#lname').on('blur', function(){
            $('#lname_icon').removeClass('active');
        });
        
        $('#addr').on('focus', function(){
            $('#addr_icon').addClass('active');
        });
        $('#addr').on('blur', function(){
            $('#addr_icon').removeClass('active');
        });
         
        $('#dob').on('focus', function(){
            $('#dob_icon').addClass('active');
        });
        $('#dob').on('blur', function(){
            $('#dob_icon').removeClass('active');
        });
        
        $('#sid').on('focus', function(){
            $('#sid_icon').addClass('active');
        });
        $('#sid').on('blur', function(){
            $('#sid_icon').removeClass('active');
        });
        
        $('#num').on('focus', function(){
            $('#num_icon').addClass('active');
        });
        $('#num').on('blur', function(){
            $('#num_icon').removeClass('active');
        });
        
        
        $('#kyc').submit(function(e) {
            e.preventDefault();
            var fname = $('#fname').val();
            var lname = $('#lname').val();
            var addr = $('#addr').val();
            var dob = $('#dob').val();
            var sid = $('#sid').val();
            var num = $('#num').val();



            $(".error").remove();

            if (fname.length < 1) {
                $('#fname_err').after('<span class="error mt3" style="color: #C73E1D;"><i class="uil uil-exclamation-triangle"></i> Your firstname is required</span>');
            }
            if (lname.length < 1) {
                $('#lname_err').after('<span class="error mt3" style="color: #C73E1D;"><i class="uil uil-exclamation-triangle"></i> Your lastname is required</span>');
            }
            if (addr.length < 1) {
                $('#addr_err').after('<span class="error mt3" style="color: #C73E1D;"><i class="uil uil-exclamation-triangle"></i> Please enter your full address</span>');
            }
            if (dob.length < 1) {
                $('#dob_err').after('<span class="error mt3" style="color: #C73E1D;"><i class="uil uil-exclamation-triangle"></i> Please enter your date of birth</span>');
            }
            if (dob.length < 10) {
                $('#dob_err').after('<span class="error mt3" style="color: #C73E1D;"><i class="uil uil-exclamation-triangle"></i> Please enter complete date of birth</span>');
            }
            if (sid.length < 1) {
                $('#sid_err').after('<span class="error mt3" style="color: #C73E1D;"><i class="uil uil-exclamation-triangle"></i> Please enter your personal identification number</span>');
            }
            if (num.length < 1) {
                $('#num_err').after('<span class="error mt3" style="color: #C73E1D;"><i class="uil uil-exclamation-triangle"></i> Please enter your phone number</span>');
            } else if (num.length < 10) {
                $('#num_err').after('<span class="error mt3" style="color: #C73E1D;"><i class="uil uil-exclamation-triangle"></i> Please enter complete phone number</span>');
            }

            if( document.getElementById("customFile").files.length == 0 ){
                $('#file_err').after('<span class="error mt3" style="color: #C73E1D;"><i class="uil uil-exclamation-triangle"></i> Please add a valid file</span>');
            }

            if( document.getElementById("customFile2").files.length == 0 ){
                $('#file_err2').after('<span class="error mt3" style="color: #C73E1D;"><i class="uil uil-exclamation-triangle"></i> Please add a valid file</span>');
            }
            
            if (fname.length > 1 && lname.length > 1 && addr.length > 1 && dob.length > 9 && sid.length > 1 && num.length > 1 && document.getElementById("customFile").files.length != 0 && document.getElementById("customFile2").files.length != 0) {
               kyc.submit();
            }
        });
        
        
    });
</script>
</body>
</html>