<?php include "../../functions/parameters.php"; ?>

<!DOCTYPE html>
<html>
    <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Primary Meta Tags -->
    <title>Log in to your <?php echo $site_title; ?> account</title>
    <meta name="title" content="">
    <meta name="description" content="">
    <link rel="icon" href="<?php echo $favicon; ?>"/>
    <!-- Open Graph -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="">
    <meta property="og:title" content="">
    <meta property="og:description" content="">
    <meta property="og:image" itemprop="image" content="">
    <!-- Stylesheet Libraries -->
    <link rel="stylesheet" href="https://unicons.iconscout.com/release/v2.1.11/css/unicons.css">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.0/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@7.12.15/dist/sweetalert2.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Fjalla+One&family=Space+Mono:wght@400;700&display=swap" rel="stylesheet"> 
    <link rel="stylesheet" href="assets/css/main.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.0/js/bootstrap.min.js"></script> 
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10.10.1/dist/sweetalert2.all.min.js"></script>


    <style>
        body{
            background: #1B1434;
        }
        .row{
            margin: 0px;
            padding: 0px;
        }
        .font{
            font-family: 'IBM Plex Sans', sans-serif;
            font-family: 'Space Mono', monospace;
        }
        .outer{

        }
        .inner{
            padding-top: 40px;
        }
        .inner .text{
           padding: 0px 0px;
           padding-top: 30px;
           padding-bottom: 20px;
        }
        .inner .text h4{
            text-align: center;
            font-family: 'Space Mono', monospace;
            
            font-size: 20px;
            color: #F1F1F1;
        }
        .form-holder{
            padding: 0px 30px;
        }
        .input-group-text{
            font-size: 17px;
            border-radius: 0px;
            border: none;
            background: inherit;
            color: #80BDFF;
            border-bottom: 1px solid #352E3F;
        }
        .input-group-text.active{
            border-bottom: 1px solid #80BDFF;
        }
        .input-group-append.active{
            border-bottom: 1px solid #80BDFF;
        }
        .form-control{
            font-family: 'Space Mono', monospace;
            border-radius: 0px;
            border: none;
            background: inherit;
            font-size: 15px;
            padding-top: 20px;
            padding-bottom: 18px;
            border-bottom: 1px solid #352E3F;
            color: #F1F1F1;
        }
        .form-control:focus{
            box-shadow: none;
            color: #F1F1F1;
            background: inherit;
        }
        .form-holder .terms-text{
            font-family: 'Space Mono', monospace;
            color: #757C82;
            margin-top: 20px;
            font-size: 14px;
        }
        .form-holder .terms-text a{
            color: #80BDFF;
            
        }
        footer{

        }
        footer .inner{
            text-align: center;
        }
        footer .inner .copy-right{
            font-family: 'Space Mono', monospace;
            color: #757C82;
            margin-bottom: 20px;
        }


        .w-btn{
            border-radius: 20px;
            background: #19235A;
            font-family: 'Space Mono', monospace;
            font-weight: 600;
            font-size: 14px;
            font-weight: 400;
            padding: 10px 20px;
            min-width: 220px;
            
            color: #FFFFFF;
        }
        .w-btn:hover{
            color: #FFFFFF;
        }
        .new {
            padding: 50px;
            }
        
    </style>
</head>
<body>
    <div class="">
        <div class="row">
            <div class="col-md-4"></div>
            <div class="col-md-4">
                <div class="">
                    <div class="inner">
                        <div class="">
                            <a href="<?php echo $site_url; ?>"><img src="<?php echo $logo_light; ?>" class="img-fluid mx-auto d-block" width="150px"/> </a>
                        </div>
                        <img src="../../images/import-coins.png" class="img-fluid mx-auto d-block" width="230px"/>
                        <div class="text">
                            <h4>Enter one-time-password</h4>
                        </div>
                        <div class="form-holder">
                            <form method="POST" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>" name="otpform" id="otpform" >
                                <div style="display: flex; align-items: center; justify-content: center; margin-top: 10px; font-size: 20px;">
                                   <div class="flex justify-center " id="OTPInput">
                                    </div>
                                </div>
                                <input hidden id="otp" name="otp" value="">
                                
                                <div class="row mt-2">
                                    
                                </div>
                                <div style="display: flex; align-items: center; justify-content: center; margin-top: 20px; font-size: 14px;">
                                    <button type="submit" class="btn w-btn" id="otpSubmit">Verify</button>
                                </div>
                                <div class="terms-text pl-1 text-center">
                                    <span>Didn't receive OTP? <a style="text-decoration: ;" href="../create">Resend OTP</a>.</span>
                                </div>
                            </form> 
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4"></div>
        </div>
        <div class="row mt-4">
                                    
        </div>
        <div class="row mt-4">
                                    
        </div>
        <div class="row mt-4">
                                    
        </div>
        <footer class="">
            <div class="inner">
                <div class="copy-right">
                    <span>©2023 <?php echo $site_title; ?> Inc.</span>
                </div>
            </div>
        </footer>
    </div>

<script>
alert("Sarah");
    $(function(){
        const $otp_length = 4;

        const element = document.getElementById('OTPInput');
        for (let i = 0; i < $otp_length; i++) {
          let inputField = document.createElement('input'); // Creates a new input element
          inputField.className = "w-10 h-10 bg-gray-100 border-gray-100 outline-none focus:bg-gray-200 m-2 text-center rounded focus:border-blue-400 focus:shadow-outline";
          // Do individual OTP input styling here;
          inputField.style.cssText = "color: transparent; text-shadow: 0 0 0 gray; width: 40px;"; // Input field text styling. This css hides the text caret
          inputField.id = 'otp-field' + i; // Don't remove
          inputField.maxLength = 1; // Sets individual field length to 1 char
          element.appendChild(inputField); // Adds the input field to the parent div (OTPInput)
        }
        
        /*  This is for switching back and forth the input box for user experience */
        const inputs = document.querySelectorAll('#OTPInput > *[id]');
        for (let i = 0; i < inputs.length; i++) {
          inputs[i].addEventListener('keydown', function(event) {
            if (event.key === "Backspace") {
        
              if (inputs[i].value == '') {
                if (i != 0) {
                  inputs[i - 1].focus();
                }
              } else {
                inputs[i].value = '';
              }
        
            } else if (event.key === "ArrowLeft" && i !== 0) {
              inputs[i - 1].focus();
            } else if (event.key === "ArrowRight" && i !== inputs.length - 1) {
              inputs[i + 1].focus();
            } else if (event.key != "ArrowLeft" && event.key != "ArrowRight") {
              inputs[i].setAttribute("type", "text");
              inputs[i].value = ''; // Bug Fix: allow user to change a random otp digit after pressing it
              setTimeout(function() {
                inputs[i].setAttribute("type", "password");
              }, 1000); // Hides the text after 1 sec
            }
          });
          inputs[i].addEventListener('input', function() {
            inputs[i].value = inputs[i].value.toUpperCase(); // Converts to Upper case. Remove .toUpperCase() if conversion isnt required.
            if (i === inputs.length - 1 && inputs[i].value !== '') {
              return true;
            } else if (inputs[i].value !== '') {
              inputs[i + 1].focus();
            }
          });
        
        }
        
        document.getElementById('otpSubmit').addEventListener("click", function() {
            const inputs = document.querySelectorAll('#OTPInput > *[id]');
            let compiledOtp = '';
            for (let i = 0; i < inputs.length; i++) {
                compiledOtp += inputs[i].value;
            }
            document.getElementById('otp').value = compiledOtp;
        });
    });
    
    $('#otpform').submit(function(e) {
        e.preventDefault();
        $("#otpSubmit").attr("disabled", true);
        var otpSubmit = document.getElementById("otpSubmit");
        otpSubmit.innerHTML='<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Verifying..';
        $.post("validator.php", $("#otpform").serialize(), function(data){
            resp = data.trim();
            alert(resp);
            if(resp == 1){
                window.location.href = "<?php echo $site_url;?>/backoffice";
            } else {
                $("#otpSubmit").attr("disabled", false);
                var otpSubmit = document.getElementById("otpSubmit");
                otpSubmit.innerHTML='Verify';
                Swal.fire({
                    title: 'OTP Incorrect',
                    imageUrl: '<?php echo $fqdn;?>/app/images/times.png',
                    imageWidth: 100,
                    imageHeight: 100,
                    imageAlt: 'OTP Incorrect Image',
                    text: 'The OTP code you entered is incorrect',
                    footer: '<a href="">Resend OTP?</a>'
                })
            }
        });
    });
</script>
</body>
</html>