<?php include "../functions/parameters.php"; ?>

<!DOCTYPE html>
<html> 
    <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Primary Meta Tags -->
    <title><?php echo $site_title; ?> Terms & Conditions</title>
    <meta name="title" content="">
    <meta name="description" content="">
    <link rel="icon" href="<?php echo $favicon; ?>"/>
    <!-- Open Graph -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="">
    <meta property="og:title" content="">
    <meta property="og:description" content="">
    <meta property="og:image" itemprop="image" content="">
    <!-- Stylesheet Libraries -->
    <link rel="stylesheet" href="https://unicons.iconscout.com/release/v2.1.11/css/unicons.css">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.0/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@7.12.15/dist/sweetalert2.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=IBM+Plex+Sans:wght@600;700&family=Space+Mono&display=swap" rel="stylesheet"> 
    <link rel="stylesheet" href="assets/css/main.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.0/js/bootstrap.min.js"></script> 
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10.10.1/dist/sweetalert2.all.min.js"></script>


    <style>
        body{
            background: #1B1434;
        }
        .row{
            margin: 0px;
            padding: 0px;
        }
        .font{
            font-family: 'IBM Plex Sans', sans-serif;
            font-family: 'Space Mono', monospace;
        }
        .outer{

        }
        .inner{
            padding: 0px 20px;
            padding-top: 40px;

        }
        .inner .text{
           padding: 0px 0px;
           padding-top: 30px;
           padding-bottom: 20px;
        }
        .inner .text h4{
            text-align: center;
            font-family: 'Space Mono', monospace;
            
            font-size: 20px;
            color: #F1F1F1;
        }
        .form-holder{
            padding: 0px 30px;
        }
        .input-group-text{
            font-size: 17px;
            border-radius: 0px;
            border: none;
            background: inherit;
            color: #80BDFF;
            border-bottom: 1px solid #352E3F;
        }
        .input-group-text.active{
            border-bottom: 1px solid #80BDFF;
        }
        .input-group-append.active{
            border-bottom: 1px solid #80BDFF;
        }
        .form-control{
            font-family: 'Space Mono', monospace;
            border-radius: 0px;
            border: none;
            background: inherit;
            font-size: 15px;
            padding-top: 20px;
            padding-bottom: 18px;
            border-bottom: 1px solid #352E3F;
            color: #F1F1F1;
        }
        .form-control:focus{
            box-shadow: none;
            color: #F1F1F1;
            background: inherit;
        }
        .form-holder .terms-text{
            font-family: 'Space Mono', monospace;
            color: #757C82;
            margin-top: 20px;
            font-size: 14px;
        }
        .form-holder .terms-text a{
            color: #80BDFF;
        }
        footer{

        }
        footer .inner{
            text-align: center;
        }
        footer .inner .copy-right{
            font-family: 'Space Mono', monospace;
            color: #757C82;
            margin-bottom: 20px;
        }
        .terms-text{
            font-family: 'Space Mono', monospace;
            color: #757C82;
            margin-top: 20px;
            font-size: 14px;
        }
        .terms-text a{
            color: #80BDFF;
            
        }

        .w-btn{
            border-radius: 20px;
            background: #19235A;
            font-family: 'Space Mono', monospace;
            font-weight: 600;
            font-size: 14px;
            font-weight: 400;
            padding: 10px 20px;
            
            color: #FFFFFF;
        }
        .w-btn:hover{
            color: #FFFFFF;
        }
        .privacy-text{
            background: #FFFFFF;
            border-radius: 10px;
            padding: 20px;
            
        }
        .privacy-text h4{
            text-align: center;
            font-size: 16px;
            font-family: 'Space Mono', monospace;
        }
        .privacy-text p{
            text-align: justify;
            font-size: 14px;
            font-family: 'Space Mono', monospace;
        }
    </style>
</head>
<body>
    <div class="">
        <div class="row">
            <div class="col-md-4"></div>
            <div class="col-md-4">
                <div class="">
                    <div class="inner">
                        <div class="">
                            <a href="<?php echo $site_url; ?>"><img src="<?php echo $logo_light; ?>" class="img-fluid mx-auto d-block" width="150px"/> </a>
                        </div>
                        <img src="../images/privacy.png" class="img-fluid mx-auto d-block" width="230px"/>
                        <div class="text">
                            <h4><?php echo $site_title; ?> Terms & Conditions<br/></h4>
                        </div>
                        <div class="privacy-text">
                            <h4>
                                Privacy Policy and Terms of Service for <?php echo $site_title; ?> Wallet<br/>
    
                            </h4>
                            <br/>
                            <p>
                              This Privacy Policy and Terms of Service ("Policy") governs 
                              the use of the <?php echo $site_title; ?> Wallet ("Wallet"), a cryptocurrency
                               wallet developed and provided by <?php echo $site_title; ?> ("we" or "us"). By using
                                the Wallet, you agree to the terms and conditions set forth in this 
                                Policy. This Policy explains how we collect, use, store, and protect 
                                your personal
                               information and the terms and conditions governing your use of the Wallet.

                                <p>1. Information Collection and Use:</p>

                                <p>a. Personal Information: We may collect certain personal information,
                                   including but not limited to your name, email address, and contact
                                    information. We collect this information to provide you with access 
                                    to the Wallet's 
                                  features and services and to improve our offerings.
                                </p>

                                <p>b. Usage Information: We may collect non-personal information about 
                                  your use of the Wallet, such as device information, IP address, and 
                                  transaction data. We use this information to analyze user behavior, 
                                  enhance the Wallet's performance, and personalize your experience.
                                </p>

                                <p>
                                  c. Third-Party Information: We do not collect information about you from
                                   third-party sources,
                                   such as blockchain networks, to enable the use of the Wallet.
                                </p>

                                <p>2. Security and Data Protection:</p>

                                <p>
                                  a. Security Measures: We implement reasonable security measures to protect your
                                   personal information from unauthorized access, disclosure, alteration, or
                                    destruction. Our method of transmission or storage is 100% secured,
                                   and we guarantee the absolute security of your information.
                                </p>

                                <p>
                                  b. Third-Party Services: We may engage third-party service providers to assist 
                                  us in providing and improving the Wallet. These providers may have access to
                                   your personal information but are bound by confidentiality 
                                  obligations and are not permitted to use your information for any other purpose.
                                </p>
                                
                                <p>
                                    c. Data Retention: We retain your personal information only for as long as necessary to 
                                    fulfill the purposes for which it was collected and to comply with legal obligations.
                                </p>

                                <p>3. Use of Information:</p>

                                <p>
                                    a. Wallet Functionality: We use your personal information to provide and improve the 
                                    Wallet's functionality, including facilitating transactions and securing your digital assets.
                                </p>

                                <p>
                                    b. Communication: We may use your email address or other contact information to send you 
                                    notifications, updates, and important information regarding the Wallet. You can opt-out of 
                                    receiving certain communications.
                                </p>

                                <p>
                                    c. Marketing: We may use your personal information to send you promotional offers or other marketing 
                                    communications. You can opt-out of receiving such communications.
                                </p>

                                <p> 4. Disclosure of Information:</p>

                                <p>
                                    a. Compliance with Law: We may disclose your personal information if required by law or if we believe 
                                    such action is necessary to comply with a legal obligation, protect our rights or interests, or prevent 
                                    fraud or illegal activities.
                                </p>

                                <p>
                                    b. Business Transfers: In the event of a merger, acquisition, or sale of all or a portion of our assets, 
                                    your personal information may be transferred as part of the transaction. We will notify you of any such 
                                    change in ownership or control.
                                </p>

                                <p> 5. Possibility of Losing Crypto:</p>

                                <p>
                                    a. Cryptocurrency Risks: The use of the Wallet involves risks associated with the loss of your digital 
                                    assets. Cryptocurrency transactions are irreversible, and if you lose access to your Wallet or private keys, 
                                    you may permanently lose your crypto. We cannot recover lost or stolen cryptocurrencies or restore access 
                                    to lost Wallets.
                                </p>

                                <p>
                                  b. Responsibility: We are solely responsible for maintaining the security 
                                  and confidentiality of your Wallet and private keys. But we recommend that
                                   you take appropriate measures to protect your digital assets,
                                   such as backing up your private keys and using multi-factor authentication.
                                </p>

                                <p> 6. Limitation of Liability:</p>

                                <p> 
                                  a. We shall not be liable for any incidental, special, consequential, or
                                   exemplary damages resulting from the use or inability to use the Ledger.
                                </p>

                                <p> 7. Governing Law and Dispute Resolution:</p>

                                <p>
                                    a. This Policy and your use of the Wallet shall be governed by and construed in accordance with the laws of 
                                    El Savador S.3666 Cryptocurrency act. Any dispute arising out of or relating to this Policy or the Wallet 
                                    shall be subject to the exclusive jurisdiction of The Supreme Electoral Court of El Salvador.
                                </p>

                                <p>
                                    b. Arbitration: Any disputes or claims arising out of or in connection with this Policy or the Wallet shall be 
                                    resolved through binding arbitration in accordance with the rules of Sáenz & Asociados Legal Practitioners. 
                                    The arbitration shall take place in Ezer, Bulevar Orden De Malta, El Salvador, in accordance to the S.3666 
                                    Cryptocurrency act, and the language of arbitration shall be Spanish.
                                </p>

                                <p> 8. Updates to the Policy:</p>

                                <p>
                                    a. We reserve the right to modify this Policy at any time. Any changes to this Policy will be effective 
                                    immediately upon posting the revised version on our website or within the Wallet. Your continued use of the 
                                    Wallet after the effective date of any modified Policy constitutes your acceptance of the modifications.
                                </p>

                                <p> 9. Third-Party Websites and Services:</p>

                                <p>
                                    a. The Wallet may contain links to third-party websites or services. We are not responsible for the privacy 
                                    practices or the content of such websites or services. We encourage you to review the privacy policies of 
                                    those third parties before providing any personal information.
                                </p>

                                <p> 10. Contact Us:</p>

                                <p>
                                    a. If you have any questions or concerns about this Policy or the Wallet, please contact us at 
                                    <?php echo $site_support_mail; ?> We will endeavor to respond to your inquiries in a timely manner.
                                </p>

                                <p> 
                                    By using the <?php echo $site_title; ?> Wallet, you acknowledge that you have read, understood, and agreed to the 
                                    terms and conditions set forth in this Privacy Policy and Terms of Service.
                                </p>
                            </p>
                        </div>
                        <div class="terms-text">
                            <span>Upon agreement, kindly proceed to creating your wallet.</span>
                        </div>
                        <div style="margin-top: 20px;">
                            <button class="btn btn-block w-btn " onclick="window.location = '../create';">Back to create account</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4"></div>
        </div>
        <div class="p-4 mt-4">
                                    
        </div>
        <div class="p-4 mt-4">
                                    
        </div>
        <div class="p-2  mt-4">
                                    
        </div>
        <footer class="">
            <div class="inner">
                <div class="copy-right">
                    <span>©2023 <?php echo $site_title; ?> Inc.</span>
                </div>
            </div>
        </footer>
    </div>
</body>
</html>