<?php include "../functions/parameters.php"; ?>

<!DOCTYPE html>
<html>
    <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Primary Meta Tags -->
    <title>Welcome aboard <?php echo $site_title; ?></title>
    <meta name="title" content="">
    <meta name="description" content="">
    <link rel="icon" href="<?php echo $favicon; ?>"/>
    <!-- Open Graph -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="">
    <meta property="og:title" content="">
    <meta property="og:description" content="">
    <meta property="og:image" itemprop="image" content="">
    <!-- Stylesheet Libraries -->
    <link rel="stylesheet" href="https://unicons.iconscout.com/release/v2.1.11/css/unicons.css">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.0/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@7.12.15/dist/sweetalert2.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=IBM+Plex+Sans:wght@600;700&family=Space+Mono&display=swap" rel="stylesheet"> 
    <link rel="stylesheet" href="assets/css/main.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.0/js/bootstrap.min.js"></script> 
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10.10.1/dist/sweetalert2.all.min.js"></script>


    <style>
        body{
            background: #1B1434;
        }
        .row{
            margin: 0px;
            padding: 0px;
        }
        .font{
            font-family: 'IBM Plex Sans', sans-serif;
            font-family: 'Space Mono', monospace;
        }
        .outer{

        }
        .inner{
            padding-top: 40px;
        }
        .inner .text{
           padding: 0px 30px;
        }
        .inner .text h4{
            text-align: center;
            font-family: 'Space Mono', monospace;
            font-weight: 600;
            font-size: 23px;
            color: #F3F2F4;
        }


        .w-tabs{
            
        }
        .w-tabs .tab{
            display: none;
        }
        .w-tabs .tab.active{
            display: block;
        }
        .w-tabs .dots{
            display: flex; 
            align-items: center; justify-content: center;
        }
        .w-tabs .dots ul{
            
            margin: 0px;
            padding: 0px;
        }
        .w-tabs .dots ul li{
            display: inline;
            margin: 0px 3px;
        }
        .w-tabs .dots button{
            background: #47484C;
            border: 2px solid #47484C;
            border-radius: 50%;
            padding: 4px;
            transition: 0.3s;
            outline: none;
        }
        .w-tabs .dots button.active{
            background: #f1f1f1;
            border: 2px solid #f1f1f1;
            border-radius: 10px;
            padding: 4px 15px;
        }

        .w-btn{
            border-radius: 20px;
            background: #19235A;
            font-family: 'Space Mono', monospace;
            font-weight: 600;
            font-size: 14px;
            font-weight: 400;
            padding: 10px 20px;
            max-width: 160px;
            min-width: 160px;
            color: #FFFFFF;
        }
        .w-btn:hover{
            color: #FFFFFF;
        }
        footer{

        }
        footer .inner{
            text-align: center;
        }
        footer .inner .copy-right{
            font-family: 'Space Mono', monospace;
            color: #757C82;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="">
        <div class="row">
            <div class="col-md-4"></div>
            <div class="col-md-4">
                <div class="">
                    <div class="inner">
                        <div class="">
                            <a href="<?php echo $fqdn; ?>"><img src="<?php echo $logo_light; ?>" class="img-fluid mx-auto d-block" width="150px"/> </a>
                        </div>
                        <div class="w-tabs">
                            <div class="tab one active" style="display: ;">
                                <img src="../images/circle-dot.png" class="img-fluid mx-auto d-block" width="400px"/>
                                <div class="text">
                                    <h4>Welcome to the <?php echo $site_type; ?> of the future!</h4>
                                </div>
                            </div>
                            <div class="tab two">
                                <img src="../images/import-coins.png" class="img-fluid mx-auto d-block" width="400px"/>
                                <div class="text">
                                    <h4>Create new wallet or import existing wallet.</h4>
                                </div>
                            </div>
                            <div class="tab three">
                                <img src="../images/trans-coin.png" class="img-fluid mx-auto d-block" width="400px"/>
                                <div class="text">
                                    <h4>Complete account setup, start transacting!</h4>
                                </div>
                            </div>

                            <div class="dots mt-4">
                                <ul>
                                    <li><button class="dot one active"></button></li>
                                    <li><button class="dot two"></button></li>
                                    <li><button class="dot three"></button></li>
                                </ul>
                            </div>

                            <div style="display: flex; align-items: center; justify-content: center; margin-top: 40px; margin-bottom: 40px; font-size: 14px;">
                                <a href="../login"><button class="btn w-btn">Get Started</button></a> 
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4"></div>
        </div>
        <footer class="">
            <div class="inner">
                <div class="copy-right">
                    <span>©2025 <?php echo $site_title; ?> Inc.</span>
                </div>
            </div>
        </footer>
    </div>
<script>
    $(function(){
        var $dot = $('.dot').click(function(){
            $dot.removeClass('active');
            $(this).addClass('active');
        });
        $('.dot.one').click(function(){
            $('.tab').removeClass('active');
            $('.tab.one').addClass('active');
        });
        $('.dot.two').click(function(){
            $('.tab').removeClass('active');
            $('.tab.two').addClass('active');
        });
        $('.dot.three').click(function(){
            $('.tab').removeClass('active');
            $('.tab.three').addClass('active');
        });
    });
</script>
</body>
</html>